/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.io;

import br.com.objectos.code.java.declaration.BodyElement;
import br.com.objectos.code.java.element.NewLine;
import br.com.objectos.code.java.io.Formatting;
import br.com.objectos.code.java.io.FormattingAction;
import br.com.objectos.code.java.io.FormattingSource;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.StreamIterable;

final class BodyElementFormatting
extends Formatting {
    static final BodyElementFormatting CONSTRUCTORS = new BodyElementFormatting(BodyElement.Kind.CONSTRUCTOR);
    static final BodyElementFormatting FIELDS = new BodyElementFormatting(BodyElement.Kind.FIELD);
    static final BodyElementFormatting METHODS = new BodyElementFormatting(BodyElement.Kind.METHOD);
    static final BodyElementFormatting TYPES = new BodyElementFormatting(BodyElement.Kind.TYPE);
    private final BodyElement.Kind kind;
    private final PostAction postAction;

    private BodyElementFormatting(BodyElement.Kind kind) {
        this(kind, NewLinePostAction.INSTANCE);
    }

    private BodyElementFormatting(BodyElement.Kind kind, PostAction postAction) {
        this.kind = kind;
        this.postAction = postAction;
    }

    @Override
    final FormattingAction newAction(FormattingAction nextAction) {
        return new ClassBodyElementFormattingAction(nextAction);
    }

    private static abstract class PostAction {
        private PostAction() {
        }

        abstract StreamIterable<BodyElement> applyTo(StreamIterable<BodyElement> var1);
    }

    private static class NewLinePostAction
    extends PostAction {
        private static final NewLinePostAction INSTANCE = new NewLinePostAction();

        private NewLinePostAction() {
        }

        @Override
        final StreamIterable<BodyElement> applyTo(StreamIterable<BodyElement> elements) {
            GrowableList result = GrowableList.newList();
            for (BodyElement element : elements) {
                result.add((Object)element);
                result.add((Object)NewLine.nl());
            }
            return result;
        }
    }

    private class ClassBodyElementFormattingAction
    extends FormattingAction {
        private ClassBodyElementFormattingAction(FormattingAction nextAction) {
            super(nextAction);
        }

        @Override
        public final void consume(FormattingSource source) {
            while (source.hasElements()) {
                BodyElement element = source.getElement();
                this.consumeElement(element);
            }
            this.nextAction(source);
        }

        @Override
        public final void consumeElement(BodyElement element) {
            if (element.hasKind(BodyElementFormatting.this.kind)) {
                this.storeElement(element);
            } else {
                this.propagateElement(element);
            }
        }

        @Override
        final StreamIterable<BodyElement> elementsStream() {
            return BodyElementFormatting.this.postAction.applyTo(super.elementsStream());
        }
    }
}

