/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.LambdaBody;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.Section;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;

public class Block
extends AbstractStatement
implements LambdaBody {
    private final ImmutableList<? extends BlockElement> elements;

    private Block(ImmutableList<? extends BlockElement> elements) {
        this.elements = elements;
    }

    public static Block of(BlockElement ... elements) {
        ImmutableList list = ImmutableList.newListWithAll((Object[])elements);
        return new Block((ImmutableList<? extends BlockElement>)list);
    }

    public static Block of(GrowableList<? extends BlockElement> elements) {
        return new Block((ImmutableList<? extends BlockElement>)elements.toImmutableList());
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return this.elements.isEmpty() ? w.writeWord('{').write('}') : this.acceptCodeWriter0(w);
    }

    @Override
    public final void acceptSemicolon(Semicolon semicolon) {
    }

    public final boolean isEmpty() {
        return this.elements.isEmpty();
    }

    private CodeWriter acceptCodeWriter0(CodeWriter w) {
        Semicolon semicolon = new Semicolon(w);
        w.writeWord('{');
        w.beginSection(Section.BLOCK);
        for (BlockElement statement : this.elements) {
            w.nextLine();
            w.beginSection(Section.STATEMENT);
            w.writeCodeElement(statement);
            w.endSection();
            statement.acceptSemicolon(semicolon);
        }
        w.nextLine();
        w.endSection();
        w.writeWord('}');
        return w;
    }

    public class Semicolon {
        private final CodeWriter w;

        private Semicolon(CodeWriter w) {
            this.w = w;
        }

        final void write() {
            this.w.spaceOff();
            this.w.write(';');
        }
    }
}

