/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.StatementOrBlockBuilder;
import br.com.objectos.comuns.lang.Preconditions;

public class DoStatement
extends AbstractStatement {
    private final CodeElement body;
    private final ExpressionCode expression;

    private DoStatement(CodeElement body, ExpressionCode expression) {
        this.body = body;
        this.expression = expression;
    }

    public static Builder _do(BlockElement ... elements) {
        return DoStatement.builder().blockBody().withBlockElement(elements);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        w.writeWord("do");
        w.writeCodeElement(this.body);
        w.writeWord("while");
        w.writeWord('(');
        w.spaceOff();
        w.writeCodeElement(this.expression);
        w.spaceOff();
        w.writeWord(')');
        return w;
    }

    public static class Builder {
        private final StatementOrBlockBuilder statementOrBlock = new StatementOrBlockBuilder();

        public final DoStatement _while(ExpressionCode expression) {
            Preconditions.checkNotNull((Object)expression, (String)"expression == null");
            return new DoStatement(this.statementOrBlock.build(), expression);
        }

        public final Builder blockBody() {
            this.statementOrBlock.forceBlock();
            return this;
        }

        final Builder withBlockElement(BlockElement ... elements) {
            Preconditions.checkNotNull((Object)elements, (String)"elements == null");
            for (BlockElement element : elements) {
                element.acceptStatementOrBlockBuilder(this.statementOrBlock);
            }
            return this;
        }
    }
}

