/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.expression.ExpressionCode;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.AbstractStatement;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.BlockElement;
import br.com.objectos.code.java.statement.IfThenElseStatement;
import br.com.objectos.code.java.statement.Statement;
import br.com.objectos.comuns.lang.Preconditions;

public class IfThenStatement
extends AbstractStatement {
    private final ExpressionCode expression;
    private final Statement statement;

    private IfThenStatement(ExpressionCode expression, Statement statement) {
        this.expression = expression;
        this.statement = statement;
    }

    static Builder builder(ExpressionCode condition) {
        Preconditions.checkNotNull((Object)condition, (String)"condition == null");
        return new Builder(condition);
    }

    public final IfThenElseStatement _else(BlockElement ... elements) {
        Block block = Block.of(elements);
        return new IfThenElseStatement(this, block);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeControl("if", this.expression).writeCodeElement(this.statement);
    }

    @Override
    public final void acceptSemicolon(Block.Semicolon semicolon) {
        this.statement.acceptSemicolon(semicolon);
    }

    public static class Builder {
        private final ExpressionCode condition;

        private Builder(ExpressionCode condition) {
            this.condition = condition;
        }

        public final IfThenStatement then(BlockElement ... elements) {
            return this.block(elements);
        }

        public final IfThenStatement block(BlockElement ... elements) {
            return this.withBlock(Block.of(elements));
        }

        public final IfThenStatement withBlock(Block block) {
            Preconditions.checkNotNull((Object)block, (String)"block == null");
            return new IfThenStatement(this.condition, block);
        }
    }
}

