/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.statement;

import br.com.objectos.code.java.element.CodeElement;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.statement.Block;
import br.com.objectos.code.java.statement.Resource;
import br.com.objectos.code.java.statement.Statement;
import br.com.objectos.code.java.statement.StatementOrBlockBuilder;
import br.com.objectos.code.java.statement.TryElement;
import br.com.objectos.code.java.statement.TryStatement;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.StreamIterator;

public class TryWithStatement
extends TryElement
implements TryStatement {
    private final ImmutableList<Resource> resources;
    private final Block block;

    private TryWithStatement(ImmutableList<Resource> resources, Block block) {
        this.resources = resources;
        this.block = block;
    }

    static Builder builder(Resource ... resources) {
        ImmutableList list = ImmutableList.newListWithAll((Object[])resources);
        return new Builder(list);
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        w.writeWord("try").writeWord('(').spaceOff();
        StreamIterator it = this.resources.iterator();
        if (it.hasNext()) {
            w.writeCodeElement((CodeElement)it.next());
            while (it.hasNext()) {
                w.spaceOff().writeWord(';');
                w.writeCodeElement((CodeElement)it.next());
            }
        }
        return w.spaceOff().writeWord(')').writeCodeElement(this.block);
    }

    @Override
    public final void acceptStatementOrBlockBuilder(StatementOrBlockBuilder builder) {
        builder.withStatement(this);
    }

    public static class Builder {
        private final ImmutableList<Resource> resources;

        private Builder(ImmutableList<Resource> resources) {
            this.resources = resources;
        }

        public final TryWithStatement block(Statement ... statements) {
            Block block = Block.of(statements);
            return new TryWithStatement(this.resources, block);
        }
    }
}

