/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.expression.CastExpression;
import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.MethodReference;
import br.com.objectos.code.java.expression.TypeWitness;
import br.com.objectos.code.java.expression.UnaryExpressionNotPlusMinus;
import br.com.objectos.code.java.io.JavaFileImportSet;
import br.com.objectos.code.java.type.AbstractTypeName;
import br.com.objectos.code.java.type.ClassNameOrParameterizedTypeName;
import br.com.objectos.code.java.type.PrimitiveTypeName;
import br.com.objectos.code.java.type.ReferenceTypeName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.code.java.type.TypeNameVisitor;
import br.com.objectos.code.java.type.TypeVariableName;
import br.com.objectos.comuns.lang.Preconditions;

public abstract class ArrayTypeName
extends AbstractTypeName
implements ReferenceTypeName {
    ArrayTypeName() {
    }

    public static ArrayTypeName of(ArrayTypeName type) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        return ArrayTypeName.ofUnchecked(type);
    }

    public static ArrayTypeName of(ClassNameOrParameterizedTypeName type) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        return ArrayTypeName.ofUnchecked(type);
    }

    public static ArrayTypeName of(PrimitiveTypeName type) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        return ArrayTypeName.ofUnchecked(type);
    }

    public static ArrayTypeName of(TypeVariableName type) {
        Preconditions.checkNotNull((Object)type, (String)"type == null");
        return ArrayTypeName.ofUnchecked(type);
    }

    static ArrayTypeName ofUnchecked(ArrayTypeName type) {
        return new MultiDimension(type);
    }

    static ArrayTypeName ofUnchecked(ClassNameOrParameterizedTypeName type) {
        return new SingleDimension(type);
    }

    static ArrayTypeName ofUnchecked(PrimitiveTypeName type) {
        return new SingleDimension(type);
    }

    static ArrayTypeName ofUnchecked(TypeVariableName type) {
        return new SingleDimension(type);
    }

    @Override
    public final String acceptJavaFileImportSet(JavaFileImportSet set) {
        return this.componentTypeName().acceptJavaFileImportSet(set) + "[]";
    }

    @Override
    public final <R, P> R acceptTypeNameVisitor(TypeNameVisitor<R, P> visitor, P p) {
        return visitor.visitArrayTypeName(this, p);
    }

    @Override
    public final TypeName arrayCreationTypeName() {
        return this.componentTypeName().arrayCreationTypeName();
    }

    @Override
    public final CastExpression cast(UnaryExpressionNotPlusMinus expression) {
        return Expressions.cast(this, expression);
    }

    public abstract TypeName componentTypeName();

    public abstract TypeName deepComponentTypeName();

    public abstract int dimension();

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayTypeName)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public abstract String printVarArgsSymbol();

    @Override
    public final MethodReference ref(String methodName) {
        return Expressions.ref(this, methodName);
    }

    @Override
    public final MethodReference ref(TypeWitness witness, String methodName) {
        return Expressions.ref(this, witness, methodName);
    }

    @Override
    public final ArrayTypeName toArrayTypeName() {
        return new MultiDimension(this);
    }

    public final String toString() {
        return this.componentTypeName() + "[]";
    }

    private static class MultiDimension
    extends ArrayTypeName {
        private final ArrayTypeName componentTypeName;

        MultiDimension(ArrayTypeName componentTypeName) {
            this.componentTypeName = componentTypeName;
        }

        @Override
        public final TypeName componentTypeName() {
            return this.componentTypeName;
        }

        @Override
        public final TypeName deepComponentTypeName() {
            return this.componentTypeName.deepComponentTypeName();
        }

        @Override
        public final int dimension() {
            return this.componentTypeName.dimension() + 1;
        }

        @Override
        public final String printVarArgsSymbol() {
            return "[]" + this.componentTypeName.printVarArgsSymbol();
        }
    }

    private static class SingleDimension
    extends ArrayTypeName {
        private final TypeName componentTypeName;

        SingleDimension(TypeName componentTypeName) {
            this.componentTypeName = componentTypeName;
        }

        @Override
        public final TypeName componentTypeName() {
            return this.componentTypeName;
        }

        @Override
        public final TypeName deepComponentTypeName() {
            return this.componentTypeName;
        }

        @Override
        public final int dimension() {
            return 1;
        }

        @Override
        public final String printVarArgsSymbol() {
            return "...";
        }
    }
}

