/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.expression.CastExpression;
import br.com.objectos.code.java.expression.Expressions;
import br.com.objectos.code.java.expression.UnaryExpression;
import br.com.objectos.code.java.io.CodeWriter;
import br.com.objectos.code.java.io.JavaFileImportSet;
import br.com.objectos.code.java.type.ArrayTypeName;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.code.java.type.TypeNameVisitor;

public enum PrimitiveTypeName implements TypeName
{
    BOOLEAN("boolean", Boolean.class),
    BYTE("byte", Byte.class),
    SHORT("short", Short.class),
    INT("int", Integer.class),
    LONG("long", Long.class),
    CHAR("char", Character.class),
    FLOAT("float", Float.class),
    DOUBLE("double", Double.class);

    private final String name;
    private final Class<?> wrapperClass;

    private PrimitiveTypeName(String name, Class<?> wrapperClass) {
        this.name = name;
        this.wrapperClass = wrapperClass;
    }

    public static PrimitiveTypeName _boolean() {
        return BOOLEAN;
    }

    public static PrimitiveTypeName _byte() {
        return BYTE;
    }

    public static PrimitiveTypeName _short() {
        return SHORT;
    }

    public static PrimitiveTypeName _int() {
        return INT;
    }

    public static PrimitiveTypeName _long() {
        return LONG;
    }

    public static PrimitiveTypeName _char() {
        return CHAR;
    }

    public static PrimitiveTypeName _float() {
        return FLOAT;
    }

    public static PrimitiveTypeName _double() {
        return DOUBLE;
    }

    @Override
    public final CodeWriter acceptCodeWriter(CodeWriter w) {
        return w.writeTypeNameAsWord(this);
    }

    @Override
    public final String acceptJavaFileImportSet(JavaFileImportSet set) {
        return this.name;
    }

    @Override
    public final <R, P> R acceptTypeNameVisitor(TypeNameVisitor<R, P> visitor, P p) {
        return visitor.visitPrimitiveType(this, p);
    }

    @Override
    public final TypeName arrayCreationTypeName() {
        return this;
    }

    public final CastExpression cast(UnaryExpression expression) {
        return Expressions.cast(this, expression);
    }

    @Override
    public final boolean isVarArgs() {
        return false;
    }

    public final ArrayTypeName toArrayTypeName() {
        return ArrayTypeName.ofUnchecked(this);
    }

    public final String toString() {
        return this.name;
    }

    public final ClassName wrapperClassName() {
        return ClassName.of(this.wrapperClass);
    }
}

