/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.java.type;

import br.com.objectos.code.java.type.AbstractTypeName;
import br.com.objectos.code.java.type.ArrayTypeName;
import br.com.objectos.code.java.type.ClassName;
import br.com.objectos.code.java.type.ParameterizedTypeName;
import br.com.objectos.code.java.type.PrimitiveTypeName;
import br.com.objectos.code.java.type.ReferenceTypeName;
import br.com.objectos.code.java.type.SimpleTypeNameVisitor;
import br.com.objectos.code.java.type.TypeName;
import br.com.objectos.code.java.type.TypeNameVisitor;
import br.com.objectos.code.java.type.TypeNames;
import br.com.objectos.code.java.type.TypeVariableName;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor8;

class TypeNameFactory
extends SimpleTypeVisitor8<TypeName, Void> {
    private static final TypeNameFactory INSTANCE = new TypeNameFactory();
    private static final TypeNameVisitor<TypeName, Void> ARRAY_HELPER = new ArrayTypeNameHelper();

    private TypeNameFactory() {
    }

    static TypeName ofUnchecked(TypeMirror type) {
        return type.accept(INSTANCE, null);
    }

    @Override
    public final TypeName visitArray(ArrayType t, Void p) {
        TypeMirror componentType = t.getComponentType();
        TypeName componentTypeName = componentType.accept(INSTANCE, null);
        return componentTypeName.acceptTypeNameVisitor(ARRAY_HELPER, null);
    }

    @Override
    public final TypeName visitDeclared(DeclaredType t, Void p) {
        TypeElement typeElement = (TypeElement)t.asElement();
        AbstractTypeName typeName = ClassName.of(typeElement);
        List<? extends TypeMirror> typeArgumentList = t.getTypeArguments();
        for (TypeMirror typeMirror : typeArgumentList) {
            typeName = typeName.withTypeArgument(typeMirror.accept(this, p));
        }
        return typeName;
    }

    @Override
    public final TypeName visitPrimitive(PrimitiveType t, Void p) {
        switch (t.getKind()) {
            case BOOLEAN: {
                return PrimitiveTypeName._boolean();
            }
            case BYTE: {
                return PrimitiveTypeName._byte();
            }
            case SHORT: {
                return PrimitiveTypeName._short();
            }
            case INT: {
                return PrimitiveTypeName._int();
            }
            case LONG: {
                return PrimitiveTypeName._long();
            }
            case CHAR: {
                return PrimitiveTypeName._char();
            }
            case FLOAT: {
                return PrimitiveTypeName._float();
            }
            case DOUBLE: {
                return PrimitiveTypeName._double();
            }
        }
        throw new AssertionError();
    }

    @Override
    public final TypeName visitWildcard(WildcardType t, Void p) {
        TypeMirror extendsBound = t.getExtendsBound();
        if (extendsBound != null) {
            return TypeNames.wildcardExtends(this.asRTN(extendsBound));
        }
        TypeMirror superBound = t.getSuperBound();
        if (superBound != null) {
            return TypeNames.wildcardSuper(this.asRTN(superBound));
        }
        return TypeNames.wildcard();
    }

    @Override
    protected final TypeName defaultAction(TypeMirror e, Void p) {
        throw new UnsupportedOperationException("Implement me: kind=" + (Object)((Object)e.getKind()));
    }

    private ReferenceTypeName asRTN(TypeMirror type) {
        TypeName typeName = type.accept(INSTANCE, null);
        return (ReferenceTypeName)typeName;
    }

    private static class ArrayTypeNameHelper
    extends SimpleTypeNameVisitor<TypeName, Void> {
        private ArrayTypeNameHelper() {
        }

        @Override
        public final TypeName visitArrayTypeName(ArrayTypeName t, Void p) {
            return t.toArrayTypeName();
        }

        @Override
        public final TypeName visitClassName(ClassName t, Void p) {
            return t.toArrayTypeName();
        }

        @Override
        public final TypeName visitParameterizedTypeName(ParameterizedTypeName t, Void p) {
            return t.toArrayTypeName();
        }

        @Override
        public final TypeName visitPrimitiveType(PrimitiveTypeName t, Void p) {
            return t.toArrayTypeName();
        }

        @Override
        public final TypeName visitTypeVariableName(TypeVariableName t, Void p) {
            return t.toArrayTypeName();
        }

        @Override
        protected final TypeName defaultAction(TypeName t, Void p) {
            throw new UnsupportedOperationException("Cannot convert " + t.getClass() + " to ArrayTypeName.");
        }
    }
}

