/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.testing;

import br.com.objectos.code.testing.CompilationTaskDsl;
import br.com.objectos.code.testing.GeneratedClassFile;
import br.com.objectos.code.testing.GeneratedJavaFile;
import br.com.objectos.code.testing.GeneratedResource;
import java.util.Map;

public class Compilation {
    private final boolean successful;
    private final String message;
    private final Map<String, ? extends GeneratedClassFile> generatedClassFiles;
    private final Map<String, ? extends GeneratedJavaFile> generatedJavaFiles;
    private final Map<String, ? extends GeneratedResource> generatedResources;

    private Compilation(Builder builder) {
        this.successful = builder.successful();
        this.message = builder.message();
        this.generatedClassFiles = builder.generatedClassFiles();
        this.generatedJavaFiles = builder.generatedJavaFiles();
        this.generatedResources = builder.generatedResources();
    }

    public static CompilationTaskDsl newTask() {
        return CompilationTaskDsl.withSystemJavaCompiler();
    }

    public final GeneratedClassFile generatedClassFile(String qualifiedName) {
        return this.generatedClassFiles.get(qualifiedName);
    }

    public final GeneratedJavaFile generatedJavaFile(String qualifiedName) {
        return this.generatedJavaFiles.get(qualifiedName);
    }

    public final GeneratedResource generatedResource(String resourceName) {
        return this.generatedResources.get(resourceName);
    }

    public final String message() {
        return this.message;
    }

    public final boolean successful() {
        return this.successful;
    }

    static abstract class Builder
    implements br.com.objectos.comuns.lang.Builder<Compilation> {
        Builder() {
        }

        public final Compilation build() {
            return new Compilation(this);
        }

        abstract boolean successful();

        abstract String message();

        abstract Map<String, ? extends GeneratedClassFile> generatedClassFiles();

        abstract Map<String, ? extends GeneratedJavaFile> generatedJavaFiles();

        abstract Map<String, ? extends GeneratedResource> generatedResources();
    }
}

