/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.testing;

import br.com.objectos.code.testing.AbstractJavaFileObject;
import java.io.IOException;
import java.net.URI;
import javax.tools.JavaFileObject;

class StringJavaFileObject
extends AbstractJavaFileObject {
    private final String qualifiedName;
    private final String source;
    private final URI uri;

    StringJavaFileObject(String qualifiedName, String source) {
        this.qualifiedName = qualifiedName;
        this.source = source;
        this.uri = URI.create("string:///" + qualifiedName.replace('.', '/') + ".java");
    }

    @Override
    public final CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.source;
    }

    @Override
    public final JavaFileObject.Kind getKind() {
        return JavaFileObject.Kind.SOURCE;
    }

    @Override
    public final String getName() {
        return this.toUri().getPath();
    }

    @Override
    public final boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return this.getKind().equals((Object)kind) && this.qualifiedName.endsWith(simpleName);
    }

    @Override
    public final URI toUri() {
        return this.uri;
    }
}

