/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.testing;

import br.com.objectos.code.testing.WritableByteArrayJavaFileObject;
import br.com.objectos.code.testing.WritableStringJavaFileObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

class CompilationJavaFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    final Map<String, WritableByteArrayJavaFileObject> generatedClassFiles = new LinkedHashMap<String, WritableByteArrayJavaFileObject>();
    final Map<String, WritableStringJavaFileObject> generatedJavaFiles = new LinkedHashMap<String, WritableStringJavaFileObject>();
    final Map<String, WritableByteArrayJavaFileObject> generatedResources = new LinkedHashMap<String, WritableByteArrayJavaFileObject>();

    CompilationJavaFileManager(JavaCompiler compiler) {
        super(compiler.getStandardFileManager(null, Locale.getDefault(), StandardCharsets.UTF_8));
    }

    @Override
    public final FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        if (StandardLocation.CLASS_OUTPUT.equals(location)) {
            String name = packageName.replace('.', '/') + relativeName;
            return this.generatedResources.computeIfAbsent(name, key -> new WritableByteArrayJavaFileObject(name, JavaFileObject.Kind.OTHER));
        }
        return super.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public final JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (StandardLocation.SOURCE_OUTPUT.equals(location)) {
            return this.generatedJavaFiles.computeIfAbsent(className, key -> new WritableStringJavaFileObject((String)key, kind));
        }
        if (StandardLocation.CLASS_OUTPUT.equals(location)) {
            return this.generatedClassFiles.computeIfAbsent(className, key -> new WritableByteArrayJavaFileObject((String)key, kind));
        }
        return super.getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public final boolean isSameFile(FileObject a, FileObject b) {
        return a.toUri().equals(b.toUri());
    }
}

