/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.testing;

import br.com.objectos.code.testing.Compilation;
import br.com.objectos.code.testing.CompilationJavaFileManager;
import br.com.objectos.code.testing.GeneratedClassFile;
import br.com.objectos.code.testing.GeneratedJavaFile;
import br.com.objectos.code.testing.GeneratedResource;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.collections.ImmutableList;
import br.com.objectos.comuns.collections.ImmutableSet;
import br.com.objectos.comuns.lang.Preconditions;
import java.io.StringWriter;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class CompilationTaskDsl {
    private final JavaCompiler compiler;
    private final GrowableList<Processor> processors = GrowableList.newList();

    private CompilationTaskDsl(JavaCompiler compiler) {
        this.compiler = compiler;
    }

    static CompilationTaskDsl withSystemJavaCompiler() {
        return new CompilationTaskDsl(ToolProvider.getSystemJavaCompiler());
    }

    public final Compilation compile(JavaFileObject ... javaFiles) {
        return this.compile((Iterable<? extends JavaFileObject>)ImmutableList.newListWithAll((Object[])javaFiles));
    }

    public final Compilation compile(Iterable<? extends JavaFileObject> javaFiles) {
        Preconditions.checkNotNull(javaFiles, (String)"javaFiles == null");
        return new CompilationBuilder(javaFiles).build();
    }

    public final CompilationTaskDsl withProcessor(Processor processor) {
        this.processors.addWithNullMessage((Object)processor, "processor == null");
        return this;
    }

    private class CompilationBuilder
    extends Compilation.Builder {
        private final Iterable<? extends JavaFileObject> javaFiles;
        private final CompilationJavaFileManager fileManager;
        private final StringWriter stdout;

        CompilationBuilder(Iterable<? extends JavaFileObject> javaFiles) {
            this.fileManager = new CompilationJavaFileManager(CompilationTaskDsl.this.compiler);
            this.stdout = new StringWriter();
            this.javaFiles = javaFiles;
        }

        @Override
        final boolean successful() {
            JavaCompiler.CompilationTask task = CompilationTaskDsl.this.compiler.getTask(this.stdout, this.fileManager, null, (Iterable<String>)ImmutableSet.empty(), (Iterable<String>)ImmutableList.empty(), this.javaFiles);
            task.setProcessors((Iterable<? extends Processor>)CompilationTaskDsl.this.processors);
            return task.call();
        }

        @Override
        final String message() {
            return this.stdout.toString();
        }

        @Override
        final Map<String, ? extends GeneratedClassFile> generatedClassFiles() {
            return this.fileManager.generatedClassFiles;
        }

        @Override
        final Map<String, ? extends GeneratedJavaFile> generatedJavaFiles() {
            return this.fileManager.generatedJavaFiles;
        }

        @Override
        final Map<String, ? extends GeneratedResource> generatedResources() {
            return this.fileManager.generatedResources;
        }
    }
}

