/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.testing;

import br.com.objectos.code.testing.GeneratedJavaFile;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class WritableStringJavaFileObject
extends SimpleJavaFileObject
implements GeneratedJavaFile {
    private final String qualifiedName;
    private String source = "";

    WritableStringJavaFileObject(String qualifiedName, JavaFileObject.Kind kind) {
        super(URI.create("writable:///" + qualifiedName.replace('.', '/') + kind.extension), kind);
        this.qualifiedName = qualifiedName;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return this.source;
    }

    @Override
    public Writer openWriter() throws IOException {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                super.close();
                WritableStringJavaFileObject.this.source = this.toString();
            }
        };
    }

    @Override
    public String qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String toString() {
        return this.source;
    }
}

