/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.code.testing;

import br.com.objectos.code.testing.Compilation;
import br.com.objectos.code.testing.CompilationJavaFileManager;
import br.com.objectos.code.testing.GeneratedClassFile;
import br.com.objectos.code.testing.GeneratedJavaFile;
import br.com.objectos.code.testing.GeneratedResource;
import br.com.objectos.code.testing.StringJavaFileObject;
import br.com.objectos.comuns.collections.Factory;
import br.com.objectos.comuns.collections.GrowableList;
import br.com.objectos.comuns.lang.Preconditions;
import java.io.StringWriter;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class CompilationTaskDsl
extends Compilation.Builder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final JavaCompiler compiler;
    private final CompilationJavaFileManager fileManager;
    private final GrowableList<JavaFileObject> javaFiles = Factory.newGrowableList();
    private final GrowableList<Processor> processors = Factory.newGrowableList();
    private final StringWriter stdout = new StringWriter();

    private CompilationTaskDsl(JavaCompiler compiler) {
        this.compiler = compiler;
        this.fileManager = new CompilationJavaFileManager(compiler);
    }

    static CompilationTaskDsl withSystemJavaCompiler() {
        return new CompilationTaskDsl(ToolProvider.getSystemJavaCompiler());
    }

    public final Compilation compile() {
        return this.build();
    }

    public final CompilationTaskDsl withCompilationUnit(String qualifiedName, String source) {
        Preconditions.checkNotNull((Object)qualifiedName, (String)"qualifiedName == null");
        Preconditions.checkNotNull((Object)source, (String)"source == null");
        this.javaFiles.add((Object)new StringJavaFileObject(qualifiedName, source));
        return this;
    }

    public final CompilationTaskDsl withCompilationUnit(String qualifiedName, String ... lines) {
        Preconditions.checkNotNull((Object)qualifiedName, (String)"qualifiedName == null");
        Preconditions.checkNotNull((Object)lines, (String)"lines == null");
        return this.withCompilationUnit(qualifiedName, String.join((CharSequence)LINE_SEPARATOR, lines));
    }

    public final CompilationTaskDsl withProcessor(Processor processor) {
        this.processors.addWithNullMessage((Object)processor, "processor == null");
        return this;
    }

    @Override
    final boolean successful() {
        JavaCompiler.CompilationTask task = this.compiler.getTask(this.stdout, this.fileManager, null, (Iterable<String>)Factory.emptyImmutableSet(), (Iterable<String>)Factory.emptyImmutableList(), (Iterable<? extends JavaFileObject>)this.javaFiles);
        task.setProcessors((Iterable<? extends Processor>)this.processors);
        return task.call();
    }

    @Override
    final String message() {
        return this.stdout.toString();
    }

    @Override
    final Map<String, ? extends GeneratedClassFile> generatedClassFiles() {
        return this.fileManager.generatedClassFiles;
    }

    @Override
    final Map<String, ? extends GeneratedJavaFile> generatedJavaFiles() {
        return this.fileManager.generatedJavaFiles;
    }

    @Override
    final Map<String, ? extends GeneratedResource> generatedResources() {
        return this.fileManager.generatedResources;
    }
}

