/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sql.code;

import br.com.objectos.sql.core.ColumnInfo;
import br.com.objectos.sql.core.ColumnType;
import br.com.objectos.sql.core.GeneratedValue;
import br.com.objectos.sql.core.ReferencedColumnInfo;
import br.com.objectos.sql.core.ReferencedColumnInfoColumnInfoAnnotationSpec;
import br.com.objectos.sql.core.TableInfo;
import br.com.objectos.sql.core.TableName;
import br.com.objectos.sql.core.annotation.Column;
import br.com.objectos.sql.core.annotation.ForeignKey;
import br.com.objectos.sql.core.annotation.PrimaryKey;
import br.com.objectos.sql.core.query.ComparisonOperator;
import br.com.objectos.sql.core.query.SortOrder;
import br.com.objectos.way.core.util.WayIterables;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;

class ColumnCode {
    private final String identifier;
    private final ClassName innerClassName;
    private final ColumnInfo columnInfo;

    private ColumnCode(String identifier, ClassName innerClassName, ColumnInfo columnInfo) {
        this.identifier = identifier;
        this.innerClassName = innerClassName;
        this.columnInfo = columnInfo;
    }

    public static ColumnCode code(ClassName tableClassName, ColumnInfo columnInfo) {
        TableName tableName = columnInfo.tableName();
        String identifier = columnInfo.identifier();
        String name = tableName.name() + "_" + columnInfo.name();
        ClassName innerClassName = tableClassName.nestedClass(name);
        return new ColumnCode(identifier, innerClassName, columnInfo);
    }

    public TypeSpec annotation() {
        List referencedColumnInfoList;
        TypeSpec.Builder annotation = TypeSpec.annotationBuilder((String)this.identifier).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(this.retentionSource()).addAnnotation(this.targetMethodParameter()).addAnnotation(this.columnAnnotation());
        if (this.columnInfo.primaryKey()) {
            annotation.addAnnotation(PrimaryKey.class);
        }
        if (this.columnInfo.autoIncrement()) {
            annotation.addAnnotation(GeneratedValue.class);
        }
        if (!(referencedColumnInfoList = this.columnInfo.referencedColumnInfoList()).isEmpty()) {
            annotation.addAnnotation(this.foreignKeyAnnotationSpec(referencedColumnInfoList));
        }
        return annotation.addMethod(this.comparisonMethod()).addMethod(this.orderByMethod()).build();
    }

    public FieldSpec field() {
        String name = this.innerClassName.simpleName();
        return FieldSpec.builder((TypeName)this.innerClassName, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{this.innerClassName}).build();
    }

    public TypeSpec inner() {
        MethodSpec privateConstructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        MethodSpec tableInfoMethod = MethodSpec.methodBuilder((String)"tableInfo").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TableInfo.class).addStatement("return TABLE", new Object[0]).build();
        MethodSpec columnInfoMethod = MethodSpec.methodBuilder((String)"columnInfo").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((Type)this.columnInfo.columnInfoType()).addStatement("return COLUMN_INFO_MAP.get$L(\"$L\")", new Object[]{this.columnInfo.typeName(), this.columnInfo.name()}).build();
        return TypeSpec.classBuilder((String)this.innerClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).superclass((Type)this.columnInfo.qualifiedColumnInfoType()).addMethod(privateConstructor).addMethod(tableInfoMethod).addMethod(columnInfoMethod).build();
    }

    public MethodSpec method() {
        String name = this.innerClassName.simpleName();
        return MethodSpec.methodBuilder((String)this.identifier).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.innerClassName).addStatement("return $L", new Object[]{name}).build();
    }

    private AnnotationSpec columnAnnotation() {
        TableName tableName = this.columnInfo.tableName();
        String name = this.columnInfo.name();
        ColumnType columnType = this.columnInfo.columnType();
        return AnnotationSpec.builder(Column.class).addMember("schema", "$S", new Object[]{tableName.schemaName()}).addMember("table", "$S", new Object[]{tableName.name()}).addMember("name", "$S", new Object[]{name}).addMember("identifier", "$S", new Object[]{this.identifier}).addMember("type", "$T.$L", new Object[]{ColumnType.class, columnType}).build();
    }

    private MethodSpec comparisonMethod() {
        return MethodSpec.methodBuilder((String)"comparison").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(ComparisonOperator.class).defaultValue("$T.$L", new Object[]{ComparisonOperator.class, ComparisonOperator.EQ}).build();
    }

    private AnnotationSpec foreignKeyAnnotationSpec(List<ReferencedColumnInfo> referencedColumnInfoList) {
        ImmutableList columnList = WayIterables.from(referencedColumnInfoList).transform(ReferencedColumnInfoColumnInfoAnnotationSpec.get()).toImmutableList();
        AnnotationSpec.Builder foreignKey = AnnotationSpec.builder(ForeignKey.class);
        for (AnnotationSpec column : columnList) {
            foreignKey.addMember("value", "$L", new Object[]{column});
        }
        return foreignKey.build();
    }

    private MethodSpec orderByMethod() {
        return MethodSpec.methodBuilder((String)"orderBy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(SortOrder.class).defaultValue("$T.$L", new Object[]{SortOrder.class, SortOrder.ASC}).build();
    }

    private AnnotationSpec retentionSource() {
        return AnnotationSpec.builder(Retention.class).addMember("value", "$T.$L", new Object[]{RetentionPolicy.class, RetentionPolicy.SOURCE}).build();
    }

    private AnnotationSpec targetMethodParameter() {
        return AnnotationSpec.builder(Target.class).addMember("value", "{ $T.$L, $T.$L }", new Object[]{ElementType.class, ElementType.METHOD, ElementType.class, ElementType.PARAMETER}).build();
    }
}

