/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Char;
import br.com.objectos.sqlreader.Cursor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class Buffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 8192;
    private final Cursor cursor;
    private final StringBuilder sql;

    private Buffer(Cursor cursor, StringBuilder sql) {
        this.cursor = cursor;
        this.sql = sql;
    }

    public static Buffer open(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in);
        Cursor cursor = new Cursor(reader, 8192);
        StringBuilder sql = new StringBuilder();
        return new Buffer(cursor, sql);
    }

    @Override
    public final void close() throws IOException {
        this.cursor.close();
    }

    public boolean cursorAt(char c) {
        return this.cursor.current() == c;
    }

    public Buffer delete(String delimiter) {
        return this.endsWith(delimiter) ? this.delete0(delimiter) : this;
    }

    public boolean hasData() {
        return this.cursor.hasData();
    }

    public final boolean endsWith(char value) {
        int length = this.sql.length();
        return length == 0 ? false : this.sql.charAt(length - 1) == value;
    }

    public boolean endsWith(String value) {
        int thatLength = value.length();
        int thisLength = this.sql.length();
        return thisLength < thatLength ? false : value.equals(this.sql.substring(thisLength - thatLength, thisLength));
    }

    public Buffer readWord() {
        this.skip(Char.whitespace());
        this.readUntil0(Char.whitespace());
        return this;
    }

    public final Buffer reset() {
        this.sql.setLength(0);
        return this;
    }

    public Buffer skip(Char ... charArray) {
        block0: while (this.cursor.ensureCapacity()) {
            for (Char c : charArray) {
                if (!c.matches(this.cursor)) continue;
                c.move(this.cursor);
                continue block0;
            }
        }
        return this;
    }

    public Buffer skipUntil(Char ... charArray) {
        while (this.cursor.ensureCapacity()) {
            for (Char c : charArray) {
                if (!c.matches(this.cursor)) continue;
                return this;
            }
            this.cursor.move();
        }
        return this;
    }

    public final String toString() {
        return this.sql.toString();
    }

    public final String toString(int ignore) {
        int length = this.sql.length();
        this.sql.delete(length - ignore, length);
        return this.sql.toString();
    }

    private Buffer delete0(String delimiter) {
        int length = this.sql.length();
        this.sql.delete(length - delimiter.length(), length);
        return this;
    }

    private void readUntil0(Char ... charArray) {
        int length = this.sql.length();
        if (length != 0 && this.sql.charAt(length - 1) != ' ') {
            this.sql.append(' ');
        }
        while (this.cursor.ensureCapacity()) {
            for (Char c : charArray) {
                if (!c.matches(this.cursor)) continue;
                return;
            }
            this.sql.append(this.cursor.current());
            this.cursor.move();
        }
    }
}

