/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Cursor;

abstract class Char {
    private static final Char LF = Char.of('\n');
    private static final Char NEWLINE = Char.of('\r', '\n');
    private static final Char SP = Char.of(' ');
    private static final Char TAB = Char.of('\t');
    private static final Char[] LINE_SEPARATOR = new Char[]{LF, NEWLINE};
    private static final Char[] WHITESPACE = new Char[]{LF, NEWLINE, SP, TAB};

    private Char() {
    }

    public static Char of(char ... chars) {
        switch (chars.length) {
            case 1: {
                return new Char1(chars[0]);
            }
            case 2: {
                return new Char2(chars[0], chars[1]);
            }
        }
        return new CharMany(chars);
    }

    public static Char[] lineSeparator() {
        return LINE_SEPARATOR;
    }

    public static Char of(String value) {
        char[] charArray = value.toCharArray();
        return Char.of(charArray);
    }

    public static Char[] whitespace() {
        return WHITESPACE;
    }

    public abstract boolean matches(Cursor var1);

    public final void move(Cursor cursor) {
        cursor.move(this.step());
    }

    abstract int step();

    private static class CharMany
    extends Char {
        private final char[] value;

        public CharMany(char[] value) {
            this.value = value;
        }

        @Override
        public boolean matches(Cursor cursor) {
            throw new UnsupportedOperationException();
        }

        @Override
        int step() {
            return this.value.length;
        }
    }

    private static class Char2
    extends Char {
        private final char value0;
        private final char value1;

        public Char2(char value0, char value1) {
            this.value0 = value0;
            this.value1 = value1;
        }

        @Override
        public boolean matches(Cursor cursor) {
            if (!cursor.canPeek()) {
                return false;
            }
            return cursor.current() == this.value0 && cursor.peek() == this.value1;
        }

        @Override
        int step() {
            return 2;
        }
    }

    private static class Char1
    extends Char {
        private final char value;

        public Char1(char value) {
            this.value = value;
        }

        @Override
        public boolean matches(Cursor cursor) {
            return cursor.current() == this.value;
        }

        @Override
        int step() {
            return 1;
        }
    }
}

