/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;

class Cursor
implements AutoCloseable {
    private final Reader reader;
    private final char[] buffer;
    private int index = 0;
    private int length = 0;

    Cursor(Reader reader, int size) {
        this.reader = reader;
        this.buffer = new char[size];
    }

    public boolean canPeek() {
        int peek = this.index + 1;
        if (peek >= this.length) {
            this.reset();
        }
        return !this.endOfReader();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public char current() {
        return this.buffer[this.index];
    }

    public boolean ensureCapacity() {
        boolean success = true;
        if (this.endOfBuffer()) {
            this.fillBuffer();
            success = !this.endOfReader();
        }
        return success;
    }

    public boolean hasData() {
        return !this.endOfBuffer() && !this.endOfReader();
    }

    public void move() {
        this.move(1);
    }

    public void move(int step) {
        if (this.index + step >= this.length) {
            this.reset();
            if (this.endOfReader()) {
                return;
            }
        }
        this.index += step;
    }

    public char peek() {
        return this.buffer[this.index + 1];
    }

    public String toString() {
        return this.endOfReader() ? "" : this.toString0();
    }

    private boolean endOfBuffer() {
        return this.index == this.length;
    }

    private boolean endOfReader() {
        return this.length <= 0;
    }

    private void fillBuffer() {
        try {
            this.index = 0;
            this.length = this.reader.read(this.buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void reset() {
        for (int i = this.index; i < this.length; ++i) {
            char copy;
            this.buffer[i - this.index] = copy = this.buffer[i];
        }
        int diff = this.buffer.length - this.index;
        try {
            this.index = 0;
            this.length = this.reader.read(this.buffer, diff, this.buffer.length - diff);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String toString0() {
        char[] copy = new char[this.length];
        System.arraycopy(this.buffer, 0, copy, 0, this.length);
        return String.valueOf(copy);
    }
}

