/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.Keyword;
import br.com.objectos.sqlreader.Result;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SqlReader
implements AutoCloseable {
    private final List<Keyword> keywordList;
    private final Buffer buffer;

    SqlReader(List<Keyword> keywordList, Buffer buffer) {
        this.keywordList = keywordList;
        this.buffer = buffer;
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public Stream<String> stream() {
        Iterator<String> it = this.iterator();
        Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(it, 272);
        return StreamSupport.stream(spliterator, false);
    }

    Iterator<String> iterator() {
        return new SqlIterator();
    }

    private class SqlIterator
    implements Iterator<String> {
        private String next;

        private SqlIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.computeNext();
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next != null || this.hasNext()) {
                String res = this.next;
                this.next = null;
                return res;
            }
            throw new NoSuchElementException();
        }

        private void computeNext() {
            block0: do {
                SqlReader.this.buffer.readWord();
                for (Keyword keyword : SqlReader.this.keywordList) {
                    Result result = keyword.execute(SqlReader.this.buffer);
                    this.next = result.get();
                    if (this.next == null) continue;
                    break block0;
                }
            } while (SqlReader.this.buffer.hasData());
        }
    }
}

