/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Action;
import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.CharKeyword;
import br.com.objectos.sqlreader.Keyword;
import br.com.objectos.sqlreader.LineCommentAction;
import br.com.objectos.sqlreader.MultiLineCommentAction;
import br.com.objectos.sqlreader.ReadStatementAction;
import br.com.objectos.sqlreader.SqlReader;
import br.com.objectos.sqlreader.SqlReaderFactoryConfigurator;
import br.com.objectos.sqlreader.StringKeyword;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SqlReaderFactory {
    private final List<Keyword> keywordList;

    private SqlReaderFactory(List<Keyword> keywordList) {
        this.keywordList = keywordList;
    }

    public static SqlReaderFactoryConfigurator configure() {
        return new Builder();
    }

    public SqlReader read(InputStream in) {
        Buffer buffer = Buffer.open(in);
        return new SqlReader(this.keywordList, buffer);
    }

    private static class Builder
    implements SqlReaderFactoryConfigurator {
        private final List<Keyword> keywordList = new ArrayList<Keyword>();

        private Builder() {
        }

        @Override
        public SqlReaderFactory build() {
            return new SqlReaderFactory(this.keywordList);
        }

        @Override
        public SqlReaderFactoryConfigurator.On on(char character) {
            return new OnChar(character);
        }

        @Override
        public SqlReaderFactoryConfigurator.On on(String keyword) {
            return new OnString(keyword);
        }

        private SqlReaderFactoryConfigurator outer() {
            return this;
        }

        private abstract class AbstractOn
        implements SqlReaderFactoryConfigurator.On {
            private AbstractOn() {
            }

            @Override
            public SqlReaderFactoryConfigurator.BeginComment beginComment() {
                return new Comment();
            }

            @Override
            public final SqlReaderFactoryConfigurator lineComment() {
                return this.keywordOf(LineCommentAction.of(this.toString()));
            }

            @Override
            public final SqlReaderFactoryConfigurator readStatement() {
                return this.keywordOf(ReadStatementAction.ONE);
            }

            abstract Keyword keyword(Action var1);

            private SqlReaderFactoryConfigurator keywordOf(Action action) {
                Builder.this.keywordList.add(this.keyword(action));
                return Builder.this.outer();
            }

            private class Comment
            implements SqlReaderFactoryConfigurator.BeginComment,
            SqlReaderFactoryConfigurator.EndComment {
                private String end;

                private Comment() {
                }

                @Override
                public SqlReaderFactoryConfigurator.EndComment on(char character) {
                    this.end = String.valueOf(character);
                    return this;
                }

                @Override
                public SqlReaderFactoryConfigurator.EndComment on(String keyword) {
                    this.end = keyword;
                    return this;
                }

                @Override
                public SqlReaderFactoryConfigurator endComment() {
                    return AbstractOn.this.keywordOf(MultiLineCommentAction.of(AbstractOn.this.toString(), this.end));
                }
            }
        }

        private class OnString
        extends AbstractOn {
            private final String keyword;

            public OnString(String keyword) {
                this.keyword = keyword;
            }

            public String toString() {
                return this.keyword;
            }

            @Override
            Keyword keyword(Action action) {
                return StringKeyword.of(this.keyword, action);
            }
        }

        private class OnChar
        extends AbstractOn {
            private final char character;

            public OnChar(char character) {
                this.character = character;
            }

            public String toString() {
                return String.valueOf(this.character);
            }

            @Override
            Keyword keyword(Action action) {
                return CharKeyword.of(this.character, action);
            }
        }
    }
}

