/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Cursor;
import br.com.objectos.sqlreader.Keyword;
import br.com.objectos.sqlreader.SqlBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

class Buffer
implements AutoCloseable {
    private static final int BUFFER_SIZE = 8192;
    private final Cursor cursor;
    private SqlBuilder sql;

    public Buffer(Cursor cursor, SqlBuilder sql) {
        this.cursor = cursor;
        this.sql = sql;
    }

    public static Buffer open(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in);
        Cursor cursor = new Cursor(reader, 8192);
        SqlBuilder sql = SqlBuilder.trimmer();
        return new Buffer(cursor, sql);
    }

    public Buffer add(char c) {
        this.sql = this.sql.add(c);
        return this;
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }

    public void consume() {
        char c = this.cursor.next();
        this.add(c);
    }

    public void consume(Keyword keyword) {
        for (int i = 0; i < keyword.size(); ++i) {
            this.consume();
        }
    }

    public Buffer delete() {
        this.sql = this.sql.delete();
        return this;
    }

    public Buffer delete(Keyword keyword) {
        return this.delete0(keyword.size());
    }

    public boolean empty() {
        return this.sql.empty();
    }

    public String get() {
        String res = this.sql.get();
        this.sql = this.sql.reset();
        return res;
    }

    public String getUntil(Keyword keyword) {
        String res = "";
        while (this.hasNext()) {
            this.consume();
            if (!keyword.matches(this)) continue;
            this.delete(keyword);
            res = this.get().trim();
            break;
        }
        return res;
    }

    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    public char last() {
        return this.sql.last();
    }

    public String nextToken() {
        StringBuilder buffer = new StringBuilder();
        while (this.cursor.hasNext()) {
            char next = this.cursor.next();
            if (Character.isWhitespace(next)) continue;
            buffer.append(next);
            break;
        }
        this.skipOver0(buffer, Keyword.whitespace());
        return buffer.toString().trim();
    }

    public String peek() {
        return this.cursor.peek();
    }

    public void rawOff() {
        this.sql = this.sql.rawOff();
    }

    public void rawOn() {
        this.sql = this.sql.rawOn();
    }

    public String right(int length) {
        return this.sql.right(length);
    }

    public int size() {
        return this.sql.size();
    }

    public Buffer skipOver(Keyword ... keywords) {
        StringBuilder buffer = new StringBuilder();
        return this.skipOver0(buffer, keywords);
    }

    public String toString() {
        return this.sql.toString();
    }

    private Buffer delete0(int size) {
        for (int i = 0; i < size; ++i) {
            this.sql = this.sql.delete();
        }
        return this;
    }

    private Buffer skipOver0(StringBuilder buffer, Keyword ... keywords) {
        while (this.cursor.hasNext()) {
            char next = this.cursor.next();
            buffer.append(next);
            for (Keyword keyword : keywords) {
                if (!keyword.matches(buffer, next)) continue;
                return this;
            }
        }
        return this;
    }
}

