/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.Keyword;

final class CharKeyword
implements Keyword {
    private final char value;

    private CharKeyword(char value) {
        this.value = value;
    }

    public static CharKeyword of(char value) {
        return new CharKeyword(value);
    }

    @Override
    public boolean matches(Buffer buffer) {
        return buffer.empty() ? false : buffer.last() == this.value;
    }

    @Override
    public boolean matches(StringBuilder sql, char next) {
        return next == this.value;
    }

    @Override
    public boolean peek(Buffer buffer) {
        return this.matches(buffer);
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        return "Keyword('" + this.value + "')";
    }
}

