/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Action;
import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.Keyword;
import java.util.Arrays;

class CommentAction
implements Action {
    private final Keyword start;
    private final Keyword[] end;

    private CommentAction(Keyword start, Keyword ... end) {
        this.start = start;
        this.end = end;
    }

    public static CommentAction delimitedBy(String start) {
        return new CommentAction(Keyword.of(start), Keyword.lineSeparator());
    }

    public static CommentAction delimitedBy(String start, String end) {
        return new CommentAction(Keyword.of(start), Keyword.of(end));
    }

    @Override
    public String execute(Buffer buffer) {
        if (this.start.matches(buffer)) {
            buffer.delete(this.start).skipOver(this.end).add(' ');
        }
        return null;
    }

    public String toString() {
        return "CommentAction(" + this.start + "," + Arrays.toString(this.end) + ")";
    }
}

