/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.NoSuchElementException;

class Cursor
implements AutoCloseable {
    private final Reader reader;
    private final char[] buffer;
    private int index = 0;
    private int length = 0;
    private boolean available;
    private char next;

    Cursor(Reader reader, int size) {
        this.reader = reader;
        this.buffer = new char[size];
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public boolean hasNext() {
        if (!this.available) {
            this.computeNext();
        }
        return this.available;
    }

    public char next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        char res = this.next;
        this.available = false;
        ++this.index;
        return res;
    }

    public String peek() {
        int peek = this.index + 1;
        if (peek >= this.length) {
            this.resetBuffer();
        }
        return this.length > 1 ? String.valueOf(this.buffer, this.index, 2) : String.valueOf(this.buffer, this.index, 1);
    }

    public String toString() {
        return this.endOfReader() ? "" : this.toString0();
    }

    private void computeNext() {
        if (this.endOfReader()) {
            return;
        }
        if (this.endOfBuffer()) {
            this.fillBuffer();
            if (this.endOfReader()) {
                return;
            }
        }
        this.available = true;
        this.next = this.buffer[this.index];
    }

    private boolean endOfBuffer() {
        return this.index == this.length;
    }

    private boolean endOfReader() {
        return this.length < 0;
    }

    private void fillBuffer() {
        try {
            this.index = 0;
            this.length = this.reader.read(this.buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void resetBuffer() {
        if (this.endOfReader()) {
            return;
        }
        if (this.endOfBuffer()) {
            this.fillBuffer();
        } else {
            this.resetBuffer0();
        }
    }

    private void resetBuffer0() {
        try {
            int offset = this.length - this.index;
            System.arraycopy(this.buffer, this.index, this.buffer, 0, offset);
            int read = this.reader.read(this.buffer, this.index, this.buffer.length - this.index);
            this.index = 0;
            this.length = read < 0 ? (offset > 0 ? offset : -1) : read + offset;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String toString0() {
        char[] copy = new char[this.length];
        System.arraycopy(this.buffer, 0, copy, 0, this.length);
        return String.valueOf(copy);
    }
}

