/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Action;
import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.Keyword;
import br.com.objectos.sqlreader.StatementAction;

class DelimiterChangeAction
implements Action {
    private final StatementAction action;
    private final Keyword keyword;

    private DelimiterChangeAction(StatementAction action, Keyword keyword) {
        this.action = action;
        this.keyword = keyword;
    }

    public static DelimiterChangeAction of(StatementAction action, String keyword) {
        return new DelimiterChangeAction(action, Keyword.of(keyword));
    }

    @Override
    public String execute(Buffer buffer) {
        if (this.keyword.matches(buffer)) {
            String newDelimiter = buffer.delete(this.keyword).nextToken();
            this.action.changeTo(newDelimiter);
        }
        return null;
    }
}

