/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.RawSqlBuilder;
import br.com.objectos.sqlreader.TrimmerSqlBuilder;
import java.util.function.Function;

abstract class SqlBuilder {
    private final StringBuilder sql;
    private int size;

    SqlBuilder(StringBuilder sql) {
        this.sql = sql;
        this.size = sql.length();
    }

    public static SqlBuilder raw() {
        StringBuilder sql = new StringBuilder();
        return new RawSqlBuilder(sql);
    }

    public static SqlBuilder trimmer() {
        StringBuilder sql = new StringBuilder();
        return new TrimmerSqlBuilder(sql);
    }

    public abstract SqlBuilder add(char var1);

    public SqlBuilder delete() {
        this.deleteLast();
        return this;
    }

    public final boolean empty() {
        return this.size == 0;
    }

    public String get() {
        return this.sql.toString();
    }

    public char last() {
        return this.sql.charAt(this.size - 1);
    }

    public SqlBuilder rawOff() {
        return this;
    }

    public SqlBuilder rawOn() {
        return new RawSqlBuilder(this.sql);
    }

    public final SqlBuilder reset() {
        this.sql.setLength(0);
        this.size = 0;
        return this.copy(TrimmerSqlBuilder::new);
    }

    public final String right(int length) {
        return this.sql.substring(this.size - length, this.size);
    }

    public final String right(int length, char next) {
        return this.right(length - 1) + next;
    }

    public final int size() {
        return this.size;
    }

    public final String toString() {
        return this.sql.toString();
    }

    void append(char c) {
        this.sql.append(c);
        ++this.size;
    }

    SqlBuilder copy(Function<StringBuilder, SqlBuilder> constructor) {
        return constructor.apply(this.sql);
    }

    void deleteLast() {
        if (!this.empty()) {
            this.sql.deleteCharAt(this.size - 1);
            --this.size;
        }
    }
}

