/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Action;
import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.SqlReaderBuilder;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SqlReader
implements AutoCloseable {
    private final List<Action> actionList;
    private final Buffer buffer;

    SqlReader(List<Action> actionList, Buffer buffer) {
        this.actionList = actionList;
        this.buffer = buffer;
    }

    public static SqlReaderBuilder configure() {
        return new SqlReaderBuilder();
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public Stream<String> stream() {
        Iterator<String> it = this.iterator();
        Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(it, 272);
        return StreamSupport.stream(spliterator, false);
    }

    Iterator<String> iterator() {
        return new SqlIterator();
    }

    private class SqlIterator
    implements Iterator<String> {
        private String next;

        private SqlIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.computeNext();
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next != null || this.hasNext()) {
                String res = this.next;
                this.next = null;
                return res;
            }
            throw new NoSuchElementException();
        }

        private void computeNext() {
            block0: while (SqlReader.this.buffer.hasNext()) {
                SqlReader.this.buffer.consume();
                for (Action action : SqlReader.this.actionList) {
                    this.next = action.execute(SqlReader.this.buffer);
                    if (this.next == null) continue;
                    break block0;
                }
            }
        }
    }
}

