/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Action;
import br.com.objectos.sqlreader.CommentAction;
import br.com.objectos.sqlreader.DelimiterChangeAction;
import br.com.objectos.sqlreader.DelimiterIgnoreAction;
import br.com.objectos.sqlreader.Keyword;
import br.com.objectos.sqlreader.SqlReaderConfiguration;
import br.com.objectos.sqlreader.StatementAction;
import br.com.objectos.sqlreader.StringAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SqlReaderBuilder {
    private final List<Action> actionList = new ArrayList<Action>();
    private StatementAction statementAction;

    SqlReaderBuilder() {
    }

    public Delimiter delimiter(char delimiter) {
        this.statementAction = StatementAction.delimitedBy(delimiter);
        this.actionList.add(this.statementAction);
        return new Delimiter();
    }

    private abstract class CanBuild {
        private CanBuild() {
        }

        public final SqlReaderConfiguration build() {
            return new SqlReaderConfiguration(SqlReaderBuilder.this.actionList);
        }
    }

    public class StringsOn {
        private final Strings strings;
        private final Keyword delimiter;

        private StringsOn(Strings strings, Keyword delimiter) {
            this.strings = strings;
            this.delimiter = delimiter;
        }

        public Strings escaping(String ... escapes) {
            Keyword[] escapeKeywords = (Keyword[])Arrays.stream(escapes).map(s -> Keyword.of(s)).toArray(Keyword[]::new);
            StringAction action = StringAction.of(this.delimiter, escapeKeywords);
            SqlReaderBuilder.this.actionList.add(action);
            return this.strings;
        }
    }

    public class Strings
    extends Comments {
        private Strings() {
        }

        public StringsOn strings(char c) {
            Keyword delimiter = Keyword.of(c);
            return new StringsOn(this, delimiter);
        }

        public StringsOn strings(String string) {
            Keyword delimiter = Keyword.of(string);
            return new StringsOn(this, delimiter);
        }
    }

    public class Delimiter
    extends Strings {
        private Delimiter() {
        }

        public Delimiter delimiterIgnore(String start, String end) {
            Keyword startKeyword = Keyword.of(start);
            Keyword endKeyword = Keyword.of(end);
            DelimiterIgnoreAction action = DelimiterIgnoreAction.of(startKeyword, endKeyword);
            SqlReaderBuilder.this.actionList.add(action);
            return this;
        }

        public Delimiter delimiterKeyword(String keyword) {
            DelimiterChangeAction action = DelimiterChangeAction.of(SqlReaderBuilder.this.statementAction, keyword);
            SqlReaderBuilder.this.actionList.add(action);
            return this;
        }
    }

    public class Comments
    extends CanBuild {
        private Comments() {
        }

        public Comments comments(String start) {
            SqlReaderBuilder.this.actionList.add(CommentAction.delimitedBy(start));
            return this;
        }

        public Comments comments(String start, String end) {
            SqlReaderBuilder.this.actionList.add(CommentAction.delimitedBy(start, end));
            return this;
        }
    }
}

