/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Action;
import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.Keyword;

class StringAction
implements Action {
    private final Keyword delimiter;
    private final Keyword[] escapes;

    private StringAction(Keyword delimiter, Keyword[] escapes) {
        this.delimiter = delimiter;
        this.escapes = escapes;
    }

    public static StringAction of(Keyword delimiter, Keyword ... escapes) {
        return new StringAction(delimiter, escapes);
    }

    @Override
    public String execute(Buffer buffer) {
        if (this.delimiter.matches(buffer)) {
            buffer.rawOn();
            block0: while (buffer.hasNext()) {
                buffer.consume();
                for (Keyword escape : this.escapes) {
                    if (!escape.peek(buffer)) continue;
                    buffer.consume(escape);
                    continue block0;
                }
                if (!this.delimiter.matches(buffer)) continue;
                buffer.rawOff();
                break;
            }
        }
        return null;
    }

    public String toString() {
        return "StringAction(" + this.delimiter + ")";
    }
}

