/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.sqlreader;

import br.com.objectos.sqlreader.Buffer;
import br.com.objectos.sqlreader.Keyword;

class StringKeyword
implements Keyword {
    private final String value;

    private StringKeyword(String value) {
        this.value = value;
    }

    public static StringKeyword of(String value) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("String cannot be empty.");
        }
        return new StringKeyword(value);
    }

    @Override
    public boolean matches(Buffer buffer) {
        int length = this.value.length();
        return buffer.size() < length ? false : this.value.equalsIgnoreCase(buffer.right(length));
    }

    @Override
    public boolean matches(StringBuilder sql, char next) {
        int thisLength = this.value.length();
        int thatLength = sql.length();
        return thatLength < thisLength ? false : this.value.equalsIgnoreCase(sql.substring(thatLength - thisLength, thatLength));
    }

    @Override
    public boolean peek(Buffer buffer) {
        return this.value.equals(buffer.peek());
    }

    @Override
    public int size() {
        return this.value.length();
    }

    public String toString() {
        return "Keyword(\"" + this.value + "\")";
    }
}

