/*
 * Decompiled with CFR 0.152.
 */
package ca.nexapp.lambdas.logging;

import ca.nexapp.lambdas.logging.LambdaLogger;
import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.context.Context;
import io.sentry.event.Breadcrumb;
import io.sentry.event.BreadcrumbBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lca/nexapp/lambdas/logging/LambdaSentryLogger;", "Lca/nexapp/lambdas/logging/LambdaLogger;", "sentryClient", "Lio/sentry/SentryClient;", "(Lio/sentry/SentryClient;)V", "sentryContext", "Lio/sentry/context/Context;", "kotlin.jvm.PlatformType", "buildBreadcrumb", "Lio/sentry/event/Breadcrumb;", "builder", "Lio/sentry/event/BreadcrumbBuilder;", "awsRuntimeContext", "Lcom/amazonaws/services/lambda/runtime/Context;", "recordHandlerError", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "recordRequest", "request", "", "recordResponse", "response", "Companion", "nexapp-aws-lambda"})
public final class LambdaSentryLogger
implements LambdaLogger {
    private final Context sentryContext;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void recordHandlerError(@NotNull Exception error, @NotNull com.amazonaws.services.lambda.runtime.Context awsRuntimeContext) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Intrinsics.checkNotNullParameter((Object)awsRuntimeContext, (String)"awsRuntimeContext");
        BreadcrumbBuilder breadcrumbBuilder = new BreadcrumbBuilder().setCategory("error").setLevel(Breadcrumb.Level.ERROR).setMessage(error.getMessage());
        boolean bl = false;
        boolean bl2 = false;
        BreadcrumbBuilder builder = breadcrumbBuilder;
        boolean bl3 = false;
        BreadcrumbBuilder breadcrumbBuilder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumbBuilder2, (String)"builder");
        Breadcrumb breadcrumb = this.buildBreadcrumb(breadcrumbBuilder2, awsRuntimeContext);
        this.sentryContext.recordBreadcrumb(breadcrumb);
        this.sentryContext.addExtra("error", (Object)error);
    }

    @Override
    public void recordResponse(@NotNull Object response, @NotNull com.amazonaws.services.lambda.runtime.Context awsRuntimeContext) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)awsRuntimeContext, (String)"awsRuntimeContext");
        BreadcrumbBuilder breadcrumbBuilder = new BreadcrumbBuilder().setCategory("response").setLevel(Breadcrumb.Level.INFO).withData("content", response.toString());
        boolean bl = false;
        boolean bl2 = false;
        BreadcrumbBuilder builder = breadcrumbBuilder;
        boolean bl3 = false;
        BreadcrumbBuilder breadcrumbBuilder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumbBuilder2, (String)"builder");
        Breadcrumb breadcrumb = this.buildBreadcrumb(breadcrumbBuilder2, awsRuntimeContext);
        this.sentryContext.recordBreadcrumb(breadcrumb);
        this.sentryContext.addExtra("response", response);
    }

    @Override
    public void recordRequest(@NotNull Object request, @NotNull com.amazonaws.services.lambda.runtime.Context awsRuntimeContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)awsRuntimeContext, (String)"awsRuntimeContext");
        BreadcrumbBuilder breadcrumbBuilder = new BreadcrumbBuilder().setCategory("request").setLevel(Breadcrumb.Level.INFO).withData("content", request.toString());
        boolean bl = false;
        boolean bl2 = false;
        BreadcrumbBuilder builder = breadcrumbBuilder;
        boolean bl3 = false;
        BreadcrumbBuilder breadcrumbBuilder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumbBuilder2, (String)"builder");
        Breadcrumb breadcrumb = this.buildBreadcrumb(breadcrumbBuilder2, awsRuntimeContext);
        this.sentryContext.addExtra("request_id", (Object)awsRuntimeContext.getAwsRequestId());
        this.sentryContext.addExtra("function_name", (Object)awsRuntimeContext.getFunctionName());
        this.sentryContext.addExtra("function_version", (Object)awsRuntimeContext.getFunctionVersion());
        this.sentryContext.addExtra("memory_limit", (Object)awsRuntimeContext.getMemoryLimitInMB());
        this.sentryContext.addExtra("maximum_execution_time", (Object)awsRuntimeContext.getRemainingTimeInMillis());
        this.sentryContext.recordBreadcrumb(breadcrumb);
        this.sentryContext.addExtra("request", request);
    }

    private final Breadcrumb buildBreadcrumb(BreadcrumbBuilder builder, com.amazonaws.services.lambda.runtime.Context awsRuntimeContext) {
        builder.withData("request_id", awsRuntimeContext.getAwsRequestId());
        builder.withData("time_remaining", awsRuntimeContext.getRemainingTimeInMillis() + "ms");
        Breadcrumb breadcrumb = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"builder.build()");
        return breadcrumb;
    }

    public LambdaSentryLogger(@NotNull SentryClient sentryClient) {
        Intrinsics.checkNotNullParameter((Object)sentryClient, (String)"sentryClient");
        this.sentryContext = sentryClient.getContext();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lca/nexapp/lambdas/logging/LambdaSentryLogger$Companion;", "", "()V", "configureDefault", "Lca/nexapp/lambdas/logging/LambdaSentryLogger;", "dsn", "", "env", "nexapp-aws-lambda"})
    public static final class Companion {
        @NotNull
        public final LambdaSentryLogger configureDefault(@NotNull String dsn, @NotNull String env) {
            SentryClient sentry;
            Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            SentryClient sentryClient = sentry = Sentry.init((String)dsn);
            Intrinsics.checkNotNullExpressionValue((Object)sentryClient, (String)"sentry");
            sentryClient.setEnvironment(env);
            return new LambdaSentryLogger(sentry);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

