/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc;

import ca.radiant3.jsonrpc.Value;
import java.util.Objects;

public class Arg {
    private final Value value;
    private String name;

    private Arg(Value value) {
        this.value = value;
    }

    public static Arg of(Value value) {
        assert (value != null);
        return new Arg(value);
    }

    public Arg named(String name) {
        this.name = name;
        return this;
    }

    public Value getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        Object result = this.isNamed() ? this.name + ":" : "";
        result = (String)result + this.value.toString();
        return result;
    }

    private boolean isNamed() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Arg arg = (Arg)o;
        return Objects.equals(this.value, arg.value) && Objects.equals(this.name, arg.name);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }
}

