/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc;

import ca.radiant3.jsonrpc.Arg;
import ca.radiant3.jsonrpc.Args;
import ca.radiant3.jsonrpc.Invocation;
import ca.radiant3.jsonrpc.Named;
import ca.radiant3.jsonrpc.Value;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Signature {
    private final Method method;
    private List<DeclaredParameter> declaredParameters;

    private Signature(Method method) {
        this.method = method;
    }

    public static Signature of(Method method) {
        Signature signature = new Signature(method);
        signature.declaredParameters = Arrays.stream(method.getParameters()).map(DeclaredParameter::of).collect(Collectors.toList());
        return signature;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public List<DeclaredParameter> parameters() {
        return Collections.unmodifiableList(this.declaredParameters);
    }

    public Type getReturnType() {
        return this.method.getGenericReturnType();
    }

    public static Predicate<Signature> hasMethodName(String name) {
        return signature -> signature.getMethodName().equals(name);
    }

    public static Predicate<Signature> hasParameters(Args params) {
        return Signature.hasParameterCount(params.count()).and(Signature.parameterTypesAreCompatible(params));
    }

    private static Predicate<Signature> hasParameterCount(int count) {
        return signature -> signature.declaredParameters.size() == count;
    }

    private static Predicate<Signature> parameterTypesAreCompatible(Args params) {
        return signature -> {
            List<Arg> list = params.list();
            for (int i = 0; i < list.size(); ++i) {
                Arg arg = list.get(i);
                DeclaredParameter declaredParam = signature.declaredParameters.get(i);
                if (arg.getValue().isCompatibleWith(declaredParam.getType())) continue;
                return false;
            }
            return true;
        };
    }

    public Object invoke(Object target, Invocation invocation) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(target, this.toArgs(this.method, invocation));
    }

    private Object[] toArgs(Method method, Invocation invocation) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Arg> args = invocation.getArguments().list();
        for (int i = 0; i < args.size(); ++i) {
            Arg parameter = args.get(i);
            Parameter param = method.getParameters()[i];
            result.add(parameter.getValue().readAs(param.getType()));
        }
        return result.toArray();
    }

    public Invocation toInvocation(List<Object> args) {
        Invocation result = Invocation.of(this.getMethodName());
        for (int i = 0; i < args.size(); ++i) {
            Object argument = args.get(i);
            DeclaredParameter parameter = this.declaredParameters.get(i);
            result.withArgument(parameter.forValue(argument));
        }
        return result;
    }

    public static class DeclaredParameter {
        private final Type type;
        private String name;

        public DeclaredParameter(Type type) {
            this.type = type;
        }

        public static DeclaredParameter of(Parameter parameter) {
            DeclaredParameter result = new DeclaredParameter(parameter.getParameterizedType());
            Named nameHint = parameter.getAnnotation(Named.class);
            if (nameHint != null) {
                result = result.named(nameHint.value());
            }
            return result;
        }

        public DeclaredParameter named(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public Arg forValue(Object argument) {
            return Arg.of(Value.of(argument, this.type)).named(this.name);
        }
    }
}

