/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.lang.model.type.NullType;

public interface Value {
    public Optional<Type> getType();

    public Object readAs(Type var1) throws ClassCastException;

    public static Value empty() {
        return Value.of(null);
    }

    public static Value of(Object value) {
        return Value.of(value, value == null ? NullType.class : value.getClass());
    }

    public static Value of(int value) {
        return Value.of(value, Integer.TYPE);
    }

    public static Value of(Object value, Type type) {
        return new TypedValue(value, type);
    }

    default public boolean isCompatibleWith(Type type) {
        try {
            this.readAs(type);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static class TypedValue
    implements Value {
        private static final Map<Class, Class> primitivesToBoxed = Map.of(Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
        private final Object value;
        private final Type type;

        private TypedValue(Object value, Type type) {
            this.value = value;
            this.type = type;
        }

        @Override
        public Optional<Type> getType() {
            return Optional.of(this.type);
        }

        @Override
        public Object readAs(Type type) {
            if (this.value == null) {
                return null;
            }
            if (type instanceof Class) {
                if (((Class)type).isPrimitive()) {
                    if (this.value.getClass().equals(primitivesToBoxed.get(type))) {
                        return this.value;
                    }
                    throw new ClassCastException("Cannot cast " + this.value + " to " + type);
                }
                return ((Class)type).cast(this.value);
            }
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypedValue that = (TypedValue)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.type);
        }

        public String toString() {
            return Objects.toString(this.value) + "<" + this.type.getTypeName() + ">";
        }
    }
}

