/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.client;

import ca.radiant3.jsonrpc.Invocation;
import ca.radiant3.jsonrpc.Signature;
import ca.radiant3.jsonrpc.client.RemoteRpcService;
import ca.radiant3.jsonrpc.protocol.payload.InvocationJson;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class RpcClientProxy
implements InvocationHandler {
    private static final int DEFAULT_TIMEOUT_SECS = 30;
    private final RemoteRpcService remoteRpcService;

    public RpcClientProxy(RemoteRpcService remoteRpcService) {
        this.remoteRpcService = remoteRpcService;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Invocation invocation = Signature.of(method).toInvocation(Arrays.asList(args));
        return ((CompletableFuture)this.remoteRpcService.invoke(InvocationJson.of(invocation)).thenApply(response -> response.getResult().readAs(method.getReturnType()))).get(30L, TimeUnit.SECONDS);
    }

    public static <T> T createFor(Class<T> service, RemoteRpcService client) {
        return (T)Proxy.newProxyInstance(RpcClientProxy.class.getClassLoader(), new Class[]{service}, (InvocationHandler)new RpcClientProxy(client));
    }
}

