/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.protocol.payload;

import ca.radiant3.jsonrpc.Arg;
import ca.radiant3.jsonrpc.Args;
import ca.radiant3.jsonrpc.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ParametersJson {
    private List<Parameter> params = new ArrayList<Parameter>();

    private ParametersJson() {
    }

    public static ParametersJson none() {
        return new ParametersJson();
    }

    public static ParametersJson unnamed(Value ... values) {
        ParametersJson params = new ParametersJson();
        Arrays.stream(values).forEach(params::add);
        return params;
    }

    public static ParametersJson unnamed(List<Value> values) {
        ParametersJson params = new ParametersJson();
        values.forEach(params::add);
        return params;
    }

    public static ParametersJson named() {
        return new ParametersJson();
    }

    public static ParametersJson of(Args arguments) {
        ParametersJson result = ParametersJson.none();
        result.params = arguments.list().stream().map(Parameter::fromParam).collect(Collectors.toList());
        return result;
    }

    private void add(Value unnamed) {
        this.params.add(new Parameter(unnamed));
    }

    public ParametersJson add(String name, Value value) {
        this.params.add(new Parameter(value).named(name));
        return this;
    }

    public List<Value> values() {
        return this.params.stream().map(Parameter::getValue).collect(Collectors.toList());
    }

    public Map<String, Value> toMap() {
        return this.params.stream().filter(Parameter::isNamed).collect(Collectors.toMap(Parameter::getName, Parameter::getValue));
    }

    public boolean hasNamedParameters() {
        return this.params.stream().anyMatch(Parameter::isNamed);
    }

    public void addTo(Args arguments) {
        this.params.forEach(p -> arguments.add(p.toParam()));
    }

    public int count() {
        return this.params.size();
    }

    public static class Parameter {
        private final Value value;
        private String name = null;

        private Parameter(Value value) {
            this.value = value;
        }

        private Parameter named(String name) {
            this.name = name;
            return this;
        }

        public boolean isNamed() {
            return this.name != null;
        }

        public String getName() {
            return this.name;
        }

        public Value getValue() {
            return this.value;
        }

        public Arg toParam() {
            Arg arg = Arg.of(this.value);
            if (this.name != null) {
                arg = arg.named(this.name);
            }
            return arg;
        }

        public static Parameter fromParam(Arg arg) {
            return new Parameter(arg.getValue()).named(arg.getName());
        }
    }
}

