/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.protocol.payload;

import ca.radiant3.jsonrpc.Value;
import ca.radiant3.jsonrpc.protocol.payload.ErrorJson;
import ca.radiant3.jsonrpc.protocol.payload.InvocationJson;
import java.io.Serializable;
import java.util.Optional;

public class ResponseJson {
    public static final String V2 = "2.0";
    private final String jsonrpc;
    private Serializable id;
    private Value result;
    private ErrorJson error;

    private ResponseJson(String version) {
        this.jsonrpc = version;
    }

    public static ResponseJson version(String version) {
        return new ResponseJson(version);
    }

    public static ResponseJson toNotification() {
        return ResponseJson.to((Serializable)((Object)((String)null)));
    }

    public static ResponseJson unboundError(ErrorJson details) {
        return ResponseJson.toNotification().error(details);
    }

    public static ResponseJson to(Serializable id) {
        return ResponseJson.version(V2).withId(id);
    }

    public static ResponseJson to(InvocationJson invocation) {
        return ResponseJson.to((Serializable)((Object)((String)null)));
    }

    public ResponseJson withId(Serializable id) {
        this.id = id;
        return this;
    }

    public ResponseJson error(ErrorJson details) {
        this.error = details;
        return this;
    }

    public ResponseJson success(Value result) {
        this.result = result;
        return this;
    }

    public Value getResult() {
        return this.result;
    }

    public ErrorJson getError() {
        return this.error;
    }

    public <T> T as(Class<T> type) {
        return Optional.ofNullable(this.result).map(value -> value.readAs(type)).orElse(null);
    }

    public Serializable getId() {
        return this.id;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }
}

