/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.protocol.serialization.gson;

import ca.radiant3.jsonrpc.Value;
import ca.radiant3.jsonrpc.protocol.payload.ErrorJson;
import ca.radiant3.jsonrpc.protocol.payload.InvocationJson;
import ca.radiant3.jsonrpc.protocol.payload.ResponseJson;
import ca.radiant3.jsonrpc.protocol.serialization.PayloadSerializer;
import ca.radiant3.jsonrpc.protocol.serialization.gson.ErrorTypeAdapter;
import ca.radiant3.jsonrpc.protocol.serialization.gson.InvocationTypeAdapter;
import ca.radiant3.jsonrpc.protocol.serialization.gson.ResponseTypeAdapter;
import ca.radiant3.jsonrpc.protocol.serialization.gson.ValueTypeAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class GsonPayloadSerializer
implements PayloadSerializer {
    private final Gson gson;

    public GsonPayloadSerializer() {
        this(new GsonBuilder());
    }

    public GsonPayloadSerializer(GsonBuilder builder) {
        Gson baseGson = builder.serializeNulls().registerTypeAdapterFactory((TypeAdapterFactory)new ValueTypeAdapterFactory()).registerTypeAdapter(ErrorJson.class, (Object)new ErrorTypeAdapter(builder.create())).create();
        this.gson = builder.registerTypeAdapter(InvocationJson.class, (Object)new InvocationTypeAdapter(baseGson)).registerTypeAdapter(ResponseJson.class, (Object)new ResponseTypeAdapter(baseGson)).create();
    }

    @Override
    public void serialize(InvocationJson invocation, OutputStream out) throws IOException {
        JsonWriter writer = this.gson.newJsonWriter((Writer)new OutputStreamWriter(out));
        this.gson.toJson((Object)invocation, InvocationJson.class, writer);
    }

    @Override
    public void serialize(ResponseJson response, OutputStream out) throws IOException {
        JsonWriter writer = this.gson.newJsonWriter((Writer)new OutputStreamWriter(out));
        this.gson.toJson((Object)response, ResponseJson.class, writer);
    }

    @Override
    public InvocationJson readInvocation(InputStream json) {
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(json));
        return (InvocationJson)this.gson.fromJson(reader, InvocationJson.class);
    }

    @Override
    public ResponseJson readResponse(InputStream json) {
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(json));
        return (ResponseJson)this.gson.fromJson(reader, ResponseJson.class);
    }

    private static class ValueTypeAdapterFactory
    implements TypeAdapterFactory {
        private ValueTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType().isAssignableFrom(Value.class)) {
                return new ValueTypeAdapter(gson);
            }
            return null;
        }
    }
}

