/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.protocol.serialization.gson;

import ca.radiant3.jsonrpc.Value;
import ca.radiant3.jsonrpc.protocol.payload.ErrorJson;
import ca.radiant3.jsonrpc.protocol.payload.ResponseJson;
import ca.radiant3.jsonrpc.protocol.serialization.gson.JsonElementValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;

public class ResponseTypeAdapter
extends TypeAdapter<ResponseJson> {
    private final Gson gson;
    private final JsonParser parser = new JsonParser();

    public ResponseTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, ResponseJson response) throws IOException {
        ErrorJson error;
        out.beginObject().name("jsonrpc").value(response.getJsonrpc());
        Serializable id = response.getId();
        out.name("id");
        if (id != null) {
            this.gson.toJson((Object)id, id.getClass(), out);
        } else {
            out.nullValue();
        }
        Value result = response.getResult();
        if (result != null) {
            out.name("result");
            this.gson.toJson((Object)result, Value.class, out);
        }
        if ((error = response.getError()) != null) {
            out.name("error");
            this.gson.toJson((Object)error, ErrorJson.class, out);
        }
        out.endObject();
        out.flush();
    }

    public ResponseJson read(JsonReader in) throws IOException {
        JsonObject payload = this.parser.parse(in).getAsJsonObject();
        ResponseJson response = ResponseJson.version(payload.get("jsonrpc").getAsString());
        Optional.ofNullable(payload.get("id")).map(id -> id.isJsonNull() ? null : Integer.valueOf(id.getAsInt())).ifPresent(response::withId);
        Optional.ofNullable(payload.get("result")).map(result -> new JsonElementValue(this.gson, (JsonElement)result)).ifPresent(response::success);
        Optional.ofNullable(payload.get("error")).map(error -> (ErrorJson)this.gson.fromJson(error, ErrorJson.class)).ifPresent(response::error);
        return response;
    }
}

