/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.server;

import ca.radiant3.jsonrpc.Invocation;
import ca.radiant3.jsonrpc.Signature;
import ca.radiant3.jsonrpc.Value;
import ca.radiant3.jsonrpc.server.InvocationHandler;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class InvokeByReflection
implements InvocationHandler {
    private final Object target;
    private final List<Signature> signatures;

    public <T> InvokeByReflection(Class<? super T> publishedInterface, T implementation) {
        this.target = implementation;
        this.signatures = Arrays.stream(publishedInterface.getMethods()).map(Signature::of).collect(Collectors.toList());
    }

    @Override
    public Value handle(Invocation invocation) throws Exception {
        Signature method = this.resolveMethod(invocation);
        return Value.of(method.invoke(this.target, invocation), method.getReturnType());
    }

    private Signature resolveMethod(Invocation invocation) throws NoSuchMethodException {
        String methodName = invocation.getMethodName();
        List remaining = this.signatures.stream().filter(Signature.hasMethodName(methodName)).collect(Collectors.toList());
        if (remaining.isEmpty()) {
            throw new NoSuchMethodException(methodName);
        }
        return remaining.stream().filter(Signature.hasParameters(invocation.getArguments())).findFirst().orElseThrow(() -> new NoSuchMethodException(methodName));
    }
}

