/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.transport.http.client;

import ca.radiant3.jsonrpc.client.RemoteRpcService;
import ca.radiant3.jsonrpc.protocol.payload.InvocationJson;
import ca.radiant3.jsonrpc.protocol.payload.ResponseJson;
import ca.radiant3.jsonrpc.protocol.serialization.PayloadSerializer;
import ca.radiant3.jsonrpc.protocol.serialization.gson.GsonPayloadSerializer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpJsonRpcClient
implements RemoteRpcService,
Closeable {
    private final String url;
    private final PayloadSerializer serializer = new GsonPayloadSerializer();
    private final CloseableHttpClient client;

    public HttpJsonRpcClient(String url) {
        this.url = url;
        this.client = HttpClientBuilder.create().build();
    }

    public static HttpJsonRpcClient create(String endpointUrl) {
        return new HttpJsonRpcClient(endpointUrl);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    @Override
    public CompletableFuture<ResponseJson> invoke(InvocationJson invocation) {
        return CompletableFuture.supplyAsync(() -> {
            HttpPost post = new HttpPost(this.url);
            try {
                ByteArrayOutputStream body = new ByteArrayOutputStream();
                this.serializer.serialize(invocation, (OutputStream)body);
                ByteArrayEntity entity = new ByteArrayEntity(body.toByteArray(), ContentType.APPLICATION_JSON);
                post.setEntity((HttpEntity)entity);
                try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);){
                    ResponseJson responseJson = this.serializer.readResponse(response.getEntity().getContent());
                    return responseJson;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not invoke remote procedure", e);
            }
        });
    }
}

