/*
 * Decompiled with CFR 0.152.
 */
package ca.radiant3.jsonrpc.transport.http.server.simpleframework;

import ca.radiant3.jsonrpc.RpcEndpoint;
import ca.radiant3.jsonrpc.protocol.InvocationPayload;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerSocketProcessor;
import org.simpleframework.transport.SocketProcessor;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFrameworkHttpRpcServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SimpleFrameworkHttpRpcServer.class);
    private final int port;
    private final EndpointRouter router;
    private SocketConnection server;

    public SimpleFrameworkHttpRpcServer(int port) {
        this.port = port;
        this.router = new EndpointRouter();
    }

    public void start() throws IOException {
        this.server = new SocketConnection((SocketProcessor)new ContainerSocketProcessor((Container)this.router));
        InetSocketAddress address = new InetSocketAddress(this.port);
        this.server.connect((SocketAddress)address);
    }

    public void stop() throws IOException {
        this.server.close();
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    public void bind(URI path, RpcEndpoint target) {
        this.router.bind(path, new RpcHandler(target));
    }

    private static class RpcHandler
    implements Container {
        private final RpcEndpoint service;

        public RpcHandler(RpcEndpoint service) {
            this.service = service;
        }

        public void handle(Request req, Response resp) {
            try {
                String contentType = req.getContentType().getType();
                try (InputStream in = req.getInputStream();){
                    InvocationPayload payload = InvocationPayload.from(in, contentType);
                    this.service.invoke(payload).thenAccept(response -> {
                        resp.setContentType(response.mimeType());
                        try {
                            OutputStream body = resp.getOutputStream();
                            response.writeTo(body);
                            body.flush();
                            resp.close();
                        }
                        catch (IOException e) {
                            log.error("Could not write response to HTTP client", (Throwable)e);
                        }
                    });
                }
            }
            catch (IOException e) {
                log.error("Could not read contents of HTTP request", (Throwable)e);
            }
        }
    }

    private static class EndpointRouter
    implements Container {
        private Map<URI, RpcHandler> routes = new HashMap<URI, RpcHandler>();

        private EndpointRouter() {
        }

        public void bind(URI path, RpcHandler target) {
            this.routes.put(path, target);
        }

        public void handle(Request req, Response resp) {
            URI path = URI.create(req.getPath().getPath());
            RpcHandler handler = this.routes.get(path);
            if (handler != null) {
                handler.handle(req, resp);
            }
        }
    }
}

