/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.config.provider;

import ca.snappay.openapi.config.ConfigurationHolder;
import ca.snappay.openapi.config.ConfigurationProvider;
import ca.snappay.openapi.config.OpenApiConfigurationExcepiton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConfigurationProviderChain
implements ConfigurationProvider {
    private final List<ConfigurationProvider> configurationProviders;

    private ConfigurationProviderChain(List<ConfigurationProvider> configurationProviders) {
        this.configurationProviders = Collections.unmodifiableList(configurationProviders);
    }

    public static ConfigurationProviderChain of(ConfigurationProvider ... configurationProviders) {
        return new ConfigurationProviderChain(Arrays.asList(configurationProviders));
    }

    @Override
    public ConfigurationHolder resolveConfiguration() {
        ArrayList<String> errorMessages = null;
        for (ConfigurationProvider provider : this.configurationProviders) {
            try {
                ConfigurationHolder config = provider.resolveConfiguration();
                return config;
            }
            catch (OpenApiConfigurationExcepiton e) {
                String message = provider + ": " + e.getMessage();
                if (errorMessages == null) {
                    errorMessages = new ArrayList<String>();
                }
                errorMessages.add(message);
            }
        }
        throw new OpenApiConfigurationExcepiton("Unable to load configuration from any of the providers in the chain " + this + " : " + errorMessages);
    }

    public String toString() {
        return "ConfigurationProviderChain";
    }
}

