/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.config.provider;

import ca.snappay.openapi.config.provider.SystemSetting;
import ca.snappay.openapi.config.provider.SystemSettingsConfigurationProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;

public class ProfileConfigurationProvider
extends SystemSettingsConfigurationProvider {
    private static final String PROFILE_FILE_PATH = System.getProperty("user.home") + "/.snappay/config";
    private final boolean fileExists;
    private final Properties properties;

    private ProfileConfigurationProvider() {
        File propertyFile = new File(PROFILE_FILE_PATH);
        this.fileExists = propertyFile.exists();
        this.properties = new Properties();
        if (this.fileExists) {
            try {
                this.properties.load(new FileInputStream(propertyFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ProfileConfigurationProvider create() {
        return new ProfileConfigurationProvider();
    }

    @Override
    protected Optional<String> loadSetting(SystemSetting setting) {
        if (!this.fileExists) {
            return Optional.empty();
        }
        String key = setting.property().replace("snappay.", "");
        return Optional.ofNullable(this.properties.getProperty(key));
    }
}

