/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request;

import ca.snappay.openapi.response.OpenApiResponse;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDateTime;
import org.apache.commons.lang.StringUtils;

public abstract class OpenApiRequest<T extends OpenApiResponse> {
    private LocalDateTime timestamp;

    public Class<T> getResponseClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public abstract String getRequestMethod();

    public boolean needMerchant() {
        return true;
    }

    public abstract void validate();

    protected void validateRequired(String fieldName, Object field) {
        if (field == null) {
            throw new IllegalArgumentException("Missing required field " + fieldName);
        }
    }

    protected void validateRequired(String fieldName, String field) {
        if (StringUtils.isEmpty((String)field)) {
            throw new IllegalArgumentException("Missing required field " + fieldName);
        }
    }

    protected void validateLength(String fieldName, String field, int maxLength) {
        if (field == null) {
            return;
        }
        if (field.trim().length() > maxLength) {
            throw new IllegalArgumentException("Field " + fieldName + " is too long, max length " + maxLength);
        }
    }

    protected void validateRange(String fieldName, int field, int min, int max) {
        if (field < min) {
            throw new IllegalArgumentException("Field " + fieldName + " is too small, min value " + min);
        }
        if (field > max) {
            throw new IllegalArgumentException("Field " + fieldName + " is too big, max value " + max);
        }
    }

    protected void validateRange(String fieldName, double field, double min, double max) {
        if (field < min) {
            throw new IllegalArgumentException("Field " + fieldName + " is too small, min value " + min);
        }
        if (field > max) {
            throw new IllegalArgumentException("Field " + fieldName + " is too big, max value " + max);
        }
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenApiRequest)) {
            return false;
        }
        OpenApiRequest other = (OpenApiRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenApiRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "OpenApiRequest(timestamp=" + this.getTimestamp() + ")";
    }
}

