/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request.misc;

import ca.snappay.openapi.constant.Currency;
import ca.snappay.openapi.constant.PaymentMethod;
import ca.snappay.openapi.constant.PaymentType;
import ca.snappay.openapi.request.OpenApiRequest;
import ca.snappay.openapi.response.misc.QueryExchangeRateResponse;
import com.google.gson.annotations.SerializedName;

public class QueryExchangeRateRequest
extends OpenApiRequest<QueryExchangeRateResponse> {
    private static final String REQUEST_METHOD = "pay.exchangerate";
    @SerializedName(value="basic_currency_unit")
    private Currency currency;
    @SerializedName(value="payment_method")
    private PaymentMethod paymentMethod;
    @SerializedName(value="pay_type")
    private PaymentType paymentType;

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public boolean needMerchant() {
        return false;
    }

    @Override
    public void validate() {
        this.validateRequired("currency", (Object)this.currency);
        this.validateRequired("paymentMethod", (Object)this.paymentMethod);
        if (this.paymentMethod == PaymentMethod.UNIONPAY) {
            throw new IllegalArgumentException("UnionPay does not support exchange rate query");
        }
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryExchangeRateRequest)) {
            return false;
        }
        QueryExchangeRateRequest other = (QueryExchangeRateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        PaymentMethod this$paymentMethod = this.getPaymentMethod();
        PaymentMethod other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !((Object)((Object)this$paymentMethod)).equals((Object)other$paymentMethod)) {
            return false;
        }
        PaymentType this$paymentType = this.getPaymentType();
        PaymentType other$paymentType = other.getPaymentType();
        return !(this$paymentType == null ? other$paymentType != null : !((Object)((Object)this$paymentType)).equals((Object)other$paymentType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof QueryExchangeRateRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        PaymentMethod $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : ((Object)((Object)$paymentMethod)).hashCode());
        PaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : ((Object)((Object)$paymentType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryExchangeRateRequest(super=" + super.toString() + ", currency=" + (Object)((Object)this.getCurrency()) + ", paymentMethod=" + (Object)((Object)this.getPaymentMethod()) + ", paymentType=" + (Object)((Object)this.getPaymentType()) + ")";
    }
}

