/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request.pay;

import ca.snappay.openapi.constant.Currency;
import ca.snappay.openapi.constant.PaymentMethod;
import ca.snappay.openapi.request.ExtensionParameters;
import ca.snappay.openapi.request.OpenApiRequest;
import ca.snappay.openapi.response.OpenApiResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public abstract class AbstractPayRequest<T extends OpenApiResponse>
extends OpenApiRequest<T> {
    @SerializedName(value="payment_method")
    private PaymentMethod paymentMethod;
    @SerializedName(value="out_order_no")
    private String orderNo;
    @SerializedName(value="trans_currency")
    private Currency currency;
    @SerializedName(value="trans_amount")
    private Double amount;
    private String description;
    @SerializedName(value="notify_url")
    private String notifyUrl;
    private JsonObject attach;
    private String longitude;
    private String latitude;
    @SerializedName(value="effective_minutes")
    private Integer effectiveMinutes;
    @SerializedName(value="extension_parameters")
    private ExtensionParameters extensionParameters;

    @Override
    public void validate() {
        this.validateRequired("paymentMethod", (Object)this.paymentMethod);
        this.validateRequired("orderNo", this.orderNo);
        this.validateLength("orderNo", this.orderNo, 64);
        this.validateRequired("amount", this.amount);
        this.validateRange("amount", this.amount, 0.0, 1.0E8);
        this.validateRequired("description", this.description);
        this.validateLength("description", this.description, 128);
        this.validateLength("notifyUrl", this.notifyUrl, 256);
        this.validateLength("longitude", this.longitude, 32);
        this.validateLength("latitude", this.latitude, 32);
        if (this.effectiveMinutes != null) {
            this.validateRange("effectiveMinutes", this.effectiveMinutes, 5, 60);
        }
        if (this.extensionParameters != null) {
            this.validateLength("extensionParameters.storeNo", this.extensionParameters.getStoreNo(), 8);
        }
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Double getAmount() {
        return this.amount;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public JsonObject getAttach() {
        return this.attach;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public Integer getEffectiveMinutes() {
        return this.effectiveMinutes;
    }

    public ExtensionParameters getExtensionParameters() {
        return this.extensionParameters;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setAttach(JsonObject attach) {
        this.attach = attach;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void setEffectiveMinutes(Integer effectiveMinutes) {
        this.effectiveMinutes = effectiveMinutes;
    }

    public void setExtensionParameters(ExtensionParameters extensionParameters) {
        this.extensionParameters = extensionParameters;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPayRequest)) {
            return false;
        }
        AbstractPayRequest other = (AbstractPayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PaymentMethod this$paymentMethod = this.getPaymentMethod();
        PaymentMethod other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !((Object)((Object)this$paymentMethod)).equals((Object)other$paymentMethod)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        Double this$amount = this.getAmount();
        Double other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        JsonObject this$attach = this.getAttach();
        JsonObject other$attach = other.getAttach();
        if (this$attach == null ? other$attach != null : !this$attach.equals(other$attach)) {
            return false;
        }
        String this$longitude = this.getLongitude();
        String other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !this$longitude.equals(other$longitude)) {
            return false;
        }
        String this$latitude = this.getLatitude();
        String other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !this$latitude.equals(other$latitude)) {
            return false;
        }
        Integer this$effectiveMinutes = this.getEffectiveMinutes();
        Integer other$effectiveMinutes = other.getEffectiveMinutes();
        if (this$effectiveMinutes == null ? other$effectiveMinutes != null : !((Object)this$effectiveMinutes).equals(other$effectiveMinutes)) {
            return false;
        }
        ExtensionParameters this$extensionParameters = this.getExtensionParameters();
        ExtensionParameters other$extensionParameters = other.getExtensionParameters();
        return !(this$extensionParameters == null ? other$extensionParameters != null : !((Object)this$extensionParameters).equals(other$extensionParameters));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractPayRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PaymentMethod $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : ((Object)((Object)$paymentMethod)).hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        Double $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        JsonObject $attach = this.getAttach();
        result = result * 59 + ($attach == null ? 43 : $attach.hashCode());
        String $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : $longitude.hashCode());
        String $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : $latitude.hashCode());
        Integer $effectiveMinutes = this.getEffectiveMinutes();
        result = result * 59 + ($effectiveMinutes == null ? 43 : ((Object)$effectiveMinutes).hashCode());
        ExtensionParameters $extensionParameters = this.getExtensionParameters();
        result = result * 59 + ($extensionParameters == null ? 43 : ((Object)$extensionParameters).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AbstractPayRequest(super=" + super.toString() + ", paymentMethod=" + (Object)((Object)this.getPaymentMethod()) + ", orderNo=" + this.getOrderNo() + ", currency=" + (Object)((Object)this.getCurrency()) + ", amount=" + this.getAmount() + ", description=" + this.getDescription() + ", notifyUrl=" + this.getNotifyUrl() + ", attach=" + this.getAttach() + ", longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ", effectiveMinutes=" + this.getEffectiveMinutes() + ", extensionParameters=" + this.getExtensionParameters() + ")";
    }
}

