/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request.pay;

import ca.snappay.openapi.constant.PaymentMethod;
import ca.snappay.openapi.request.pay.AbstractPayRequest;
import ca.snappay.openapi.response.pay.BarCodePayResponse;
import com.google.gson.annotations.SerializedName;

public class BarCodePayRequest
extends AbstractPayRequest<BarCodePayResponse> {
    private static final String REQUEST_METHOD = "pay.barcodepay";
    @SerializedName(value="auth_code")
    private String authCode;

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getPaymentMethod() == PaymentMethod.UNIONPAY) {
            throw new IllegalArgumentException("UnionPay does not support barcode payment");
        }
        this.validateRequired("authCode", this.authCode);
        this.validateLength("authCode", this.authCode, 32);
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BarCodePayRequest)) {
            return false;
        }
        BarCodePayRequest other = (BarCodePayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        return !(this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BarCodePayRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BarCodePayRequest(super=" + super.toString() + ", authCode=" + this.getAuthCode() + ")";
    }
}

