/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.request.pay;

import ca.snappay.openapi.constant.BrowserType;
import ca.snappay.openapi.constant.PaymentMethod;
import ca.snappay.openapi.request.pay.AbstractPayRequest;
import ca.snappay.openapi.response.pay.WebsitePayResponse;
import com.google.gson.annotations.SerializedName;

public class WebsitePayRequest
extends AbstractPayRequest<WebsitePayResponse> {
    private static final String REQUEST_METHOD = "pay.webpay";
    @SerializedName(value="browser_type")
    private BrowserType browserType;
    @SerializedName(value="return_url")
    private String returnUrl;

    @Override
    public String getRequestMethod() {
        return REQUEST_METHOD;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getPaymentMethod() == PaymentMethod.WECHATPAY) {
            throw new IllegalArgumentException("WeChatPay does not support website payment");
        }
        if (this.getPaymentMethod() == PaymentMethod.UNIONPAY && this.browserType == BrowserType.WAP) {
            throw new IllegalArgumentException("UnionPay does not support WAP browser");
        }
        this.validateLength("returnUrl", this.returnUrl, 256);
    }

    public BrowserType getBrowserType() {
        return this.browserType;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setBrowserType(BrowserType browserType) {
        this.browserType = browserType;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsitePayRequest)) {
            return false;
        }
        WebsitePayRequest other = (WebsitePayRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BrowserType this$browserType = this.getBrowserType();
        BrowserType other$browserType = other.getBrowserType();
        if (this$browserType == null ? other$browserType != null : !((Object)((Object)this$browserType)).equals((Object)other$browserType)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebsitePayRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BrowserType $browserType = this.getBrowserType();
        result = result * 59 + ($browserType == null ? 43 : ((Object)((Object)$browserType)).hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebsitePayRequest(super=" + super.toString() + ", browserType=" + (Object)((Object)this.getBrowserType()) + ", returnUrl=" + this.getReturnUrl() + ")";
    }
}

