/*
 * Decompiled with CFR 0.152.
 */
package ca.snappay.openapi.sign;

import ca.snappay.openapi.LocalDateTimeTypeAdapter;
import ca.snappay.openapi.config.ConfigurationHolder;
import ca.snappay.openapi.sign.MD5;
import ca.snappay.openapi.sign.RSA;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;

public class SignHandler {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeTypeAdapter()).disableHtmlEscaping().create();

    public static String sign(ConfigurationHolder config, JsonObject params) {
        String sign = null;
        switch (config.getSignType()) {
            case MD5: {
                sign = SignHandler.signWithMD5(params, config.getPrivateKey());
                break;
            }
            case RSA: {
                sign = SignHandler.signWithRSA(params, config.getPrivateKey());
            }
        }
        if (StringUtils.isEmpty(sign)) {
            return null;
        }
        return sign;
    }

    public static boolean verifySign(ConfigurationHolder config, JsonObject params) {
        String sign = params.get("sign").getAsString();
        if (StringUtils.isEmpty((String)sign)) {
            return true;
        }
        boolean isPass = false;
        switch (config.getSignType()) {
            case MD5: {
                String signStr = SignHandler.signWithMD5(params, config.getPrivateKey());
                if (StringUtils.isEmpty((String)signStr)) {
                    return false;
                }
                isPass = sign.equals(signStr);
                break;
            }
            case RSA: {
                isPass = SignHandler.verifySignWithRSA(params, config.getPublicKey(), sign);
            }
        }
        return isPass;
    }

    private static String signWithMD5(JsonObject sParaTemp, String signatureKey) {
        String prestr = SignHandler.createLinkString(sParaTemp);
        String mysign = MD5.md5sign(prestr, signatureKey, "UTF-8");
        return mysign;
    }

    private static String signWithRSA(JsonObject sParaTemp, String privateKey) {
        String prestr = SignHandler.createLinkString(sParaTemp);
        String mysign = RSA.sign(prestr, privateKey, "UTF-8");
        return mysign;
    }

    private static boolean verifySignWithRSA(JsonObject sParaTemp, String publicKey, String sign) {
        String prestr = SignHandler.createLinkString(sParaTemp);
        return RSA.verify(prestr, sign, publicKey, "UTF-8");
    }

    private static JsonElement paraFilter(JsonElement param) {
        if (param.isJsonNull()) {
            return null;
        }
        if (param.isJsonPrimitive()) {
            if (StringUtils.isEmpty((String)param.getAsString())) {
                return null;
            }
            return param;
        }
        if (param.isJsonArray()) {
            JsonArray array = new JsonArray();
            for (JsonElement item : param.getAsJsonArray()) {
                JsonElement result = SignHandler.paraFilter(item);
                if (result == null) continue;
                array.add(item);
            }
            return array;
        }
        boolean hasItem = false;
        JsonObject object = new JsonObject();
        for (String key : param.getAsJsonObject().keySet()) {
            JsonElement value;
            JsonElement result;
            if ("sign".equals(key) || "sign_type".equals(key) || (result = SignHandler.paraFilter(value = param.getAsJsonObject().get(key))) == null) continue;
            hasItem = true;
            object.add(key, result);
        }
        if (hasItem) {
            return object;
        }
        return null;
    }

    private static String createLinkString(JsonObject params) {
        params = SignHandler.paraFilter((JsonElement)params).getAsJsonObject();
        ArrayList keys = new ArrayList(params.keySet());
        Collections.sort(keys);
        StringBuilder prestr = new StringBuilder();
        for (String key : keys) {
            JsonElement value = params.get(key);
            if (value.isJsonPrimitive()) {
                prestr.append(key).append("=").append(value.getAsString()).append("&");
                continue;
            }
            if (value.isJsonArray()) {
                prestr.append(key).append("=").append(GSON.toJson((JsonElement)value.getAsJsonArray())).append("&");
                continue;
            }
            if (!value.isJsonObject()) continue;
            prestr.append(key).append("=").append(GSON.toJson((JsonElement)value.getAsJsonObject())).append("&");
        }
        return prestr.deleteCharAt(prestr.length() - 1).toString();
    }
}

